% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zeros.R
\name{Zeros}
\alias{Zeros}
\title{Finds zeros of a function within a specified domain}
\usage{
Zeros(tilde, domain = NULL, ..., nsegs = 131)
}
\arguments{
\item{tilde}{tilde expression defining a function, suitable
for \code{makeFun()}}

\item{domain}{specification of domain, as in \code{slice_plot()}}

\item{\dots}{Assignments to parameters}

\item{nsegs}{Subdivide the domain into this many segments, looking for a zero
in each of those segments. This helps to find multiple zeros.}
}
\value{
A data frame with two columns. The first has the name
of the input in the tilde expression, and gives the values
for that input at which the function is approximately zero.
The second column, \code{.output.} gives
the actual value of the function at the inputs in the first column.
}
\description{
Finds zeros of a function within a specified domain
}
\examples{
Zeros(a*x + b ~ x, a=1, b=2)

}
