% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survFit.R
\name{priors_survData}
\alias{priors_survData}
\title{Create a list of scalars giving priors to use in Bayesian inference.}
\usage{
priors_survData(x, model_type = NULL)
}
\arguments{
\item{x}{An object of class \code{survData}}

\item{model_type}{TKTD model type ('SD' or 'IT')}
}
\value{
A list for parameterization of priors for Bayesian inference with JAGS.
}
\description{
Create a list of scalars giving priors to use in Bayesian inference.
}
\examples{

# (1) Load the data
data(cadmium1)

# (2) Create a survData object
dat <- survData(cadmium1)

# (3) Create priors for SD model_type
priors_survData(dat, model_type = "SD")

# (4) Create priors for IT model_type
priors_survData(dat, model_type = "IT")

}
