% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation-metrics.R
\name{mean_squared_error}
\alias{mean_squared_error}
\alias{mean_ranked_score}
\alias{classification_error}
\title{Accuracy Measures for Ordered Probability Predictions}
\usage{
mean_squared_error(y, predictions, use.true = FALSE)

mean_ranked_score(y, predictions, use.true = FALSE)

classification_error(y, predictions)
}
\arguments{
\item{y}{Either the observed outcome vector or a matrix of true probabilities.}

\item{predictions}{Predictions.}

\item{use.true}{If \code{TRUE}, then the program treats \code{y} as a matrix of true probabilities.}
}
\value{
The MSE, the RPS, or the classification error of the method.
}
\description{
Accuracy measures for evaluating ordered probability predictions.
}
\details{
\subsection{MSE and RPS}{

When calling \code{\link{mean_squared_error}} or \code{\link{mean_ranked_score}}, \code{predictions} must be a matrix of predicted
class probabilities, with as many rows as observations in \code{y} and as many columns as classes of \code{y}.\cr

If \code{use.true == FALSE}, the mean squared error (MSE) and the mean ranked probability score (RPS) are computed as follows:

\deqn{MSE = \frac{1}{n} \sum_{i = 1}^n \sum_{m = 1}^M (1 (Y_i = m) - \hat{p}_m (x))^2}

\deqn{RPS = \frac{1}{n} \sum_{i = 1}^n \frac{1}{M - 1} \sum_{m = 1}^M (1 (Y_i \leq m) - \hat{p}_m^* (x))^2}

If \code{use.true == TRUE}, the MSE and the RPS are computed as follows (useful for simulation studies):

\deqn{MSE = \frac{1}{n} \sum_{i = 1}^n \sum_{m = 1}^M (p_m (x) - \hat{p}_m (x))^2}

\deqn{RPS = \frac{1}{n} \sum_{i = 1}^n \frac{1}{M - 1} \sum_{m = 1}^M (p_m^* (x) - \hat{p}_m^* (x))^2}

where:

\deqn{p_m (x) = P(Y_i = m | X_i = x)}

\deqn{p_m^* (x) = P(Y_i \leq m | X_i = x)}
}

\subsection{Classification error}{

When calling \code{\link{classification_error}}, \code{predictions} must be a vector of predicted class labels.\cr

Classification error is computed as follows:

\deqn{CE = \frac{1}{n} \sum_{i = 1}^n 1 (Y_i \neq \hat{Y}_i)}

where Y_i are the observed class labels.
}
}
\examples{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:200, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Training-test split.
train_idx <- sample(seq_len(length(y)), floor(length(y) * 0.5))

y_tr <- y[train_idx]
X_tr <- X[train_idx, ]

y_test <- y[-train_idx]
X_test <- X[-train_idx, ]

## Fit morf on training sample.
forests <- morf(y_tr, X_tr)

## Accuracy measures on test sample.
predictions <- predict(forests, X_test)

mean_squared_error(y_test, predictions$probabilities)
mean_ranked_score(y_test, predictions$probabilities)
classification_error(y_test, predictions$classification)

}
\seealso{
\code{\link{mean_ranked_score}}
}
\author{
Riccardo Di Francesco
}
