% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialCov.R
\name{plotSpatialCov}
\alias{plotSpatialCov}
\title{Plot observations on raster image}
\usage{
plotSpatialCov(data, spatialCov, segments = TRUE, compact = TRUE,
  col = NULL, alpha = 1, size = 1, states = NULL, animals = NULL,
  ask = TRUE, return = FALSE)
}
\arguments{
\item{data}{Data frame of the location data, with necessary fields 'x' (longitudinal direction) and
'y' (latitudinal direction).}

\item{spatialCov}{\code{\link[raster]{RasterLayer-class}} object on which to plot the location data}

\item{segments}{\code{TRUE} if segments should be plotted between the observations (default),
\code{FALSE} otherwise.}

\item{compact}{\code{FALSE} if tracks should be plotted separately, \code{TRUE}
otherwise (default).}

\item{col}{Palette of colours to use for the dots and segments. If not specified, uses default palette.}

\item{alpha}{Transparency argument for \code{\link{geom_point}}.}

\item{size}{Size argument for \code{\link{geom_point}}.}

\item{states}{A sequence of integers, corresponding to the decoded states for these data. If
specified, the observations are colored by states.}

\item{animals}{Vector of indices or IDs of animals/tracks to be plotted.
Default: \code{NULL}; all animals are plotted.}

\item{ask}{If \code{TRUE}, the execution pauses between each plot.}

\item{return}{If \code{TRUE}, the function returns a ggplot object (which can be edited and
plotted manually). If \code{FALSE}, the function automatically plots the map (default).}
}
\description{
Plot tracking data over a raster layer.
}
\examples{
stepDist <- "gamma"
angleDist <- "vm"

# plot simulated data over forest raster automatically loaded with the packge
spatialCov<-list(forest=forest)
data <- simData(nbAnimals=2,nbStates=2,dist=list(step=stepDist,angle=angleDist),
                Par=list(step=c(100,1000,50,100),angle=c(0,0,0.1,5)),
                beta=matrix(c(5,-10,-25,50),nrow=2,ncol=2,byrow=TRUE),
                formula=~forest,spatialCovs=spatialCov,
                obsPerAnimal=225,states=TRUE)

plotSpatialCov(data,forest,states=data$states)

}
