% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pennies.R
\docType{data}
\name{pennies_sample}
\alias{pennies_sample}
\title{A sample of 50 pennies}
\format{A data frame of 50 rows representing 50 sampled pennies and 2 variables
\describe{
  \item{ID}{Variable used to uniquely identify each penny.}
  \item{year}{Year of minting.}
}}
\usage{
pennies_sample
}
\description{
A sample of 50 pennies contained in a 50 cent roll from Florence Bank on
Friday February 1, 2019 in downtown Northampton, Massachusetts, USA 
\url{https://goo.gl/maps/AF88fpvVfm12}.
}
\note{
The original \code{pennies_sample} has been renamed \code{\link{orig_pennies_sample}} 
as of \code{moderndive} v0.3.0.
}
\examples{
library(ggplot2)

ggplot(pennies_sample, aes(x = year)) +
 geom_histogram(binwidth = 5, boundary = 2000)
}
\keyword{datasets}
