% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_correlation.R
\name{get_correlation}
\alias{get_correlation}
\title{Get correlation value in a tidy way}
\usage{
get_correlation(data, formula)
}
\arguments{
\item{data}{a data frame object}

\item{formula}{a formula with the response variable name on the left and the explanatory variable name on the right}
}
\value{
A 1x1 data frame storing the correlation value
}
\description{
Determine the Pearson correlation coefficient between two variables in
a data frame using pipeable and formula-friendly syntax
}
\examples{
library(moderndive)

# Compute correlation between mpg and cyl:
mtcars \%>\% 
   get_correlation(formula = mpg ~ cyl)
}
