% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsummary_list.R
\name{glance.modelsummary_list}
\alias{glance.modelsummary_list}
\title{Extract goodness-of-fit statistics from a \code{modelsummary_list} object.}
\usage{
\method{glance}{modelsummary_list}(x, ...)
}
\arguments{
\item{x}{a list of class \code{modelsummary_list} (see Examples section)}

\item{...}{other parameters are accepted by ignored}
}
\description{
A \code{modelsummary_list} is a simple list which holds two data.frames names
"glance" and "tidy", and to which we have attached the class
"modelsummary_list". This allows us to manually create objects that will be
printed nicely by \code{modelsummary} (see Examples section).
}
\examples{
\dontrun{
mod <- list(
  tidy = data.frame(term = c("A", "B"),
                    estimate = 1:2,
                    std.error = 3:4),
  glance = data.frame(nobs = 10))
class(mod) <- c("modelsummary_list", class(mod))

modelsummary(mod)
}
}
