% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_model_mode.R
\name{set_model_mode}
\alias{set_model_mode}
\title{Register Mode for Model}
\usage{
set_model_mode(model, mode)
}
\arguments{
\item{model}{A single character string for the model type (e.g. "k_means",
etc).}

\item{mode}{A single character string for the model mode (e.g. "partition").}
}
\value{
NULL invisibly
}
\description{
This function is used to register a mode for a model.
}
\details{
This function can be called multiple times without error. This becomes
valuable when multiple packages adds the same mode to a model. Having both
packages use \code{set_model_mode()} avoids having one package depend on the
other.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_new_model("shallow_learning_model")

get_from_env("shallow_learning_model_modes")

set_model_mode("shallow_learning_model", "partition")

get_from_env("shallow_learning_model_modes")
\dontshow{\}) # examplesIf}
}
