% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_contrasts.bayesian.R
\name{estimate_contrasts}
\alias{estimate_contrasts}
\title{Estimate contrasts between factor levels}
\usage{
estimate_contrasts(
  model,
  levels = NULL,
  fixed = NULL,
  modulate = NULL,
  transform = "none",
  length = 10,
  standardize = TRUE,
  standardize_robust = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{levels}{A character vector or formula specifying the names of the
predictors over which to estimate means or contrasts.}

\item{fixed}{A character vector indicating the names of the predictors to be
"fixed" (i.e., maintained), so that the estimation is made at these values.}

\item{modulate}{A character vector indicating the names of a numeric variable
along which the means or the contrasts will be estimated. Adjust its length
using \code{length}.}

\item{transform}{Can be \code{"none"} (default for contrasts),
\code{"response"} (default for means), \code{"mu"}, \code{"unlink"},
\code{"log"}. \code{"none"}  will leave the values on scale of the linear
predictors. \code{"response"} will transform them on scale of the response
variable. Thus for a logistic model, \code{"none"} will give estimations
expressed in log-odds (probabilities on logit scale) and \code{"response"}
in terms of probabilities.}

\item{length}{Length of the spread numeric variables.}

\item{standardize}{If \code{TRUE}, adds standardized differences or
coefficients.}

\item{standardize_robust}{Robust standardization through \code{MAD} (Median
Absolute Deviation, a robust estimate of SD) instead of regular \code{SD}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame of estimated contrasts.
}
\description{
Contrast analysis. See the documentation for your object's class:
\itemize{
 \item{\link[=estimate_contrasts.lm]{Frequentist models}}
 \item{\link[=estimate_contrasts.stanreg]{Bayesian models}}
}
}
