% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_smooth.R
\name{estimate_smooth.stanreg}
\alias{estimate_smooth.stanreg}
\title{Describe the smooth term (for GAMs) or non-linear predictors}
\usage{
\method{estimate_smooth}{stanreg}(
  model,
  smooth = NULL,
  levels = NULL,
  length = 200,
  transform = "response",
  centrality = "median",
  ...
)
}
\arguments{
\item{model}{A Bayesian model.}

\item{smooth}{A character indicating the name of the "smooth" term.}

\item{levels}{A character vector indicating the variables over which the slope will be computed. If NULL (default), it will select all the remaining predictors.}

\item{length}{Passed to \code{\link{visualisation_matrix}} if \code{data = "grid"}.}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Describe the smooth term (for GAMs) or non-linear predictors
}
\examples{
library(modelbased)
\donttest{
if (require("rstanarm")) {
  model <- stan_gamm4(Sepal.Width ~ s(Petal.Length), data = iris)
  estimate_smooth(model)

  model <- stan_glm(Sepal.Width ~ poly(Petal.Length, 2), data = iris)
  estimate_smooth(model)

  model <- stan_gamm4(Sepal.Width ~ Species + s(Petal.Length), data = iris)
  estimate_smooth(model)

  model <- stan_glm(Sepal.Width ~ Species * poly(Petal.Length, 2), data = iris)
  estimate_smooth(model)
  estimate_smooth(model, levels = "Species")
}
}
}
