% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mpox_19801984_DRC}
\alias{mpox_19801984_DRC}
\title{A dataset of mpox outbreaks in DRC}
\format{
A data frame (\code{data.frame}) with 125 rows of records, and 3 columns of variables:
\describe{
\item{\code{obs.seed}}{Observations of the number of seed cases that generated the offspring cases in the next transmission generation.}
\item{\code{obs.size}}{Observations of cases numbers generated by given numbers (given in \code{obs.seed}) of seed cases, see \code{type} variable for the detailed meaning of the value recorded under this variable here.}
\item{\code{type}}{
A categorical variable takes one of the 3 values indicating the type of observations for \code{obs.size} as follows:
\itemize{
\item{\code{"offpring"}}{ indicated the \strong{offspring case number}, generated by 1 seed case for each observation.}
\item{\code{"nextgen"}}{ indicated the \strong{next-generation cluster size} (including seed cases), generated by a group of seed cases with size given in \code{obs.seed}.}
\item{\code{"outbreak"}}{ indicated the \strong{final outbreak size} (including seed cases), generated by a group of seed cases with size given in \code{obs.seed}.}
}
}
}
}
\usage{
mpox_19801984_DRC
}
\description{
This dataset (i.e., \code{mpox_19801984_DRC}) contains 125 observations of one of the following types:
\itemize{
\item{\strong{offspring case number}}{, }
\item{\strong{next-generation cluster size}}{, and }
\item{\strong{final outbreak size}}{, }
}
generated by given numbers of seed cases,
which were collected in mpox (i.e., monkeypox) outbreaks in Democratic Republic of the Congo (DRC, or previous named "Zaire" before 1997) from 1980 to 1984.
}
\details{
Note one difference between \code{mpox_19801984_DRC} and the original dataset (i.e., the dataset presented in reference) was that for simplicity, observations in the original dataset that involved transmission chains of more than 1 generation were aggregated as \strong{final outbreak size} observations in \code{mpox_19801984_DRC}.
}
\examples{
data(mpox_19801984_DRC)
summary(mpox_19801984_DRC)
table(mpox_19801984_DRC$type)

}
\references{
Fine PE, Jezek Z, Grab B, Dixon H. The transmission potential of monkeypox virus in human populations. \emph{International Journal of Epidemiology}. 1988;17(3):643-650.
\doi{10.1093/ije/17.3.643}, see Table 1 for the raw data.
}
\keyword{datasets}
