% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mmpca.R
\name{mmpca}
\alias{mmpca}
\title{Multiview principal component analysis}
\usage{
mmpca(x, inds, k, lambda = NULL, trace = 0, init_theta = TRUE,
  cachepath = NULL, enable_rank_selection = TRUE, enable_sparsity = TRUE,
  enable_variable_selection = FALSE, parallel = TRUE)
}
\arguments{
\item{x}{List of matrices to analyze}

\item{inds}{Matrix containing view indices. The matrix should have two
columns and the same number of rows as the length of \code{x}. The first
(second) column contains the view index of the rows (columns) of the
corresponding matrix.}

\item{k}{Integer giving the maximum rank of the analysis, i.e. the maximum
number of principal components for each view.}

\item{lambda}{Vector or matrix of lambda values. The length (or width if it
is a matrix) depends on the number of active penalties (2, 3 or 4). If it
is a matrix, try different lambda values (one try for each row). Default: a
matrix where each column is the sequence \code{exp(seq(-6, 0)))}.}

\item{trace}{Integer selecting the amount of log messages. 0 (default): no
output, 3: all output.}

\item{init_theta}{Boolean or numeric. TRUE (default) use collaborative
matrix factorization (CMF) to find initial values. FALSE use initial
values based on ordinary SVD. If init_theta is a numeric vector it is used
as initial value.}

\item{cachepath}{Character vector with path to directory to store
intermediate results. If NULL (default) intermediate results are not
stored. For caching to work it is required that the random number
generation seed is constant between calls to mmpca, so \code{set.seed}
needs to be called before mmpca.}

\item{enable_rank_selection}{Boolean deciding if the second penalty that
imposes a low rank model should be enabled.}

\item{enable_sparsity}{Boolean deciding if the third penalty that imposes
sparsity in V should be enabled.}

\item{enable_variable_selection}{Boolean deciding if the fourth penalty that
increases the tendence for sparsity structure of different V columns to be
similar. Defaults to FALSE meaning this penalty is not used.}

\item{parallel}{Boolean deciding if computations should be run on multiple
  cores simultaneously.}
}
\value{
A list with components
  \item{initial}{initial values used in optimization}
  \item{cmf}{solution found with CMF (if init_theta == TRUE)}
  \item{training}{solutions for different values of lambda}
  \item{solution}{solution for optimal lambda value}
}
\description{
Analyzes several related matrices of data.
}
\examples{
x <- list(matrix(rnorm(110), 10, 11), matrix(rnorm(120), 10, 12))
inds <- matrix(c(1, 1, 2, 3), 2, 2)
result <- mmpca(x, inds, 3, init_theta=FALSE, parallel=FALSE)
}
\author{
Jonatan Kallus, \email{kallus@chalmers.se}
}
\keyword{models}
\keyword{multivariate}
\keyword{pca}

