% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinymlx.R
\name{shinymlx}
\alias{shinymlx}
\title{Automatic code generation for Shiny applications}
\usage{
shinymlx(model, parameter = NULL, output = NULL, treatment = NULL,
  data = NULL, appname = "shinymlxApp", style = "basic",
  settings = NULL, title = " ")
}
\arguments{
\item{model}{a \code{Mlxtran} or \code{PharmML} model used for the simulation}

\item{parameter}{a vector, or a list of shiny widgets}

\item{output}{a list - or a list of lists - with fields: 
\itemize{
  \item \code{name}: a vector of output names
  \item \code{time}: a vector of times, or a vector (min, max, step)
}}

\item{treatment}{a list with fields 
\itemize{
  \item \code{tfd} : first time of dose,
  \item \code{amount} : amount,
  \item \code{nd} : number of doses,
  \item \code{ii} : interdose interval,
  \item \code{type} : the type of input,
}
Input argument of Simulx can also be used,  i.e. a list with fields \code{time}, 
\code{amount}, \code{rate}, \code{tinf}, \code{type}, \code{target}.}

\item{data}{a datafile to display with the plot}

\item{appname}{the name of the application (and possibly its path)}

\item{style}{the style of the Shiny app
\itemize{
  \item \code{"basic"}: basic Shiny app with a single side bar (default)
  \item \code{"navbar1"}: navigation bar and tabPanels (including outputs)
  \item \code{"navbar2"}: navigation bar and tabPanels (outputs separated)
  \item \code{"dashboard1"} : Shiny dashboard,
}}

\item{settings}{a list of settings
\itemize{
  \item \code{"tabstyle"} : look of the tabs c("tabs","pills"),
  \item \code{"select.x"} : display the list of variables available for the x-axis c(TRUE,FALSE),
  \item \code{"select.y"} : display the list of variables available for the y-axis c(TRUE,FALSE),
  \item \code{"select.log"} : log scale option c(TRUE,FALSE),
  \item \code{"select.ref"} : reference curves option c(TRUE,FALSE)
}}

\item{title}{the title of the application}
}
\value{
A Shiny app with files ui.R, server.R and model.txt
}
\description{
Creates a Shiny application for longitudinal data model
}
\details{
shinymlx automatically generates files ui.R and server.R required 
for a Shiny application.

Elements of \code{parameters} and \code{treatment} can be either scalars or lists.
A scalar automatically generates a slider with default minimum and maximum values and default step. 
A list may contain the type of widget ("slider", "select", "numeric") and the settings defining the widget: 
(value, min, max, step) for \code{slider}, (selected, choices) for \code{select} and
value for \code{numeric}.

See http://simulx.webpopix.org/mlxr/shinymlx/ for more details.
}
\examples{
\dontrun{
library(mlxR)
PKPDmodel <- inlineModel("
[LONGITUDINAL] 
input={ka,V,Cl,Imax,IC50,S0,kout}
EQUATION:
C     = pkmodel(ka, V, Cl)
E_0   = S0 
ddt_E = kout*((1-Imax*C/(C+IC50))*S0- E)  
")

p1  <- c(ka=0.5, V=10, Cl=1)
p2  <- c(Imax=0.5, IC50=0.03, S0=100, kout=0.1)
adm <- list(tfd=5, nd=15, ii=12, amount=1)
f1  <- list(name = 'C', time = seq(0, 250, by=1))
f2  <- list(name = 'E', time = seq(0, 250, by=1))
f   <- list(f1, f2)

shinymlx(model=PKPDmodel, treatment=adm, parameter=list(p1,p2), output=f,
         style="dashboard1")

#------------------------------------------------------------------------
p1 <- list(
  ka    = list(widget="slider", value=0.5, min=0.1, max=2,  step=0.1),
  V     = list(widget="slider", value=10,  min=2,   max=20, step=2),
  Cl    = list(widget="slider", value=1,   min=0.1, max=2,  step=0.1)
)  
adm <- list(
  tfd    = list(widget="slider", value=5,  min=0, max=100, step=5),
  nd     = list(widget="numeric", value=15),
  ii     = list(widget="select", selected=12, choices=c(3,6,12,18,24)),
  amount = list(widget="slider", value=40, min=0, max=50, step=5)
)
s <- list(select.x=FALSE, select.y=FALSE)
shinymlx(model=PKPDmodel, treatment=adm, parameter=list(p1,p2), output=f, 
         style="navbar1", settings=s)
}
}

