% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{attachCPO}
\alias{attachCPO}
\title{Attach a CPO to a Learner}
\usage{
attachCPO(cpo, learner)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The cpo.}

\item{learner}{[\code{\link[mlr:makeLearner]{Learner}}]\cr
The learner.}
}
\description{
A \code{\link{CPO}} object can be attached to a \code{\link[mlr:makeLearner]{Learner}} object to create a
pipeline combining preprocessing and model fitting. When the resulting \code{\link{CPOLearner}}
is used to create a model using \code{\link[mlr]{train}}, the attached CPO will be applied to the
data before the internal model is trained. The resulting model will also contain the required
\code{\link{CPOTrained}} elements, and apply the necessary \code{\link{CPORetrafo}} objects to new prediction
data, and the \code{\link{CPOInverter}} objects to predictions made by the internal model.

The \code{\link{\%>>\%}} operator can be used synonymously to attach CPO objects to Learners.
}
\seealso{
Other operators: \code{\link{CPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{composeCPO}}, \code{\link{pipeCPO}}

Other CPO lifecycle related: \code{\link{CPOConstructor}},
  \code{\link{CPOLearner}}, \code{\link{CPOTrained}},
  \code{\link{CPO}}, \code{\link{NULLCPO}},
  \code{\link{\%>>\%}}, \code{\link{composeCPO}},
  \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{identicalCPO}}, \code{\link{makeCPO}}

Other CPOLearner related: \code{\link{CPOLearner}},
  \code{\link{getLearnerBare}}, \code{\link{getLearnerCPO}}
}
