% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_spcv_buffer.R
\name{autoplot.ResamplingSpCVBuffer}
\alias{autoplot.ResamplingSpCVBuffer}
\alias{plot.ResamplingSpCVBuffer}
\title{Visualization Functions for SpCV Buffer Methods.}
\usage{
\method{autoplot}{ResamplingSpCVBuffer}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  ...
)

\method{plot}{ResamplingSpCVBuffer}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSpCVBuffer}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
a list with of \CRANpkg{ggplot2} objects is returned.
Only applies if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{...}{Passed to \code{geom_sf()}. Helpful for adjusting point sizes and
shapes.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSpCVBuffer}.}
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods to
visualize mlr3 spatiotemporal resampling objects.
}
\examples{
\donttest{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task = tsk("ecuador")
  resampling = rsmp("spcv_buffer", theRange = 1000)
  resampling$instantiate(task)

  ## single fold
  autoplot(resampling, task, fold_id = 1) +
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))

  ## multiple folds
  autoplot(resampling, task, fold_id = c(1, 2)) *
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))
}
}
}
\seealso{
\itemize{
\item mlr3book chapter on on \href{https://mlr3book.mlr-org.com/spatiotemporal.html#vis-spt-partitions}{"Spatiotemporal Visualization"}.
\item \code{\link[=autoplot.ResamplingSpCVBlock]{autoplot.ResamplingSpCVBlock()}}
\item \code{\link[=autoplot.ResamplingSpCVCoords]{autoplot.ResamplingSpCVCoords()}}
\item \code{\link[=autoplot.ResamplingSpCVEnv]{autoplot.ResamplingSpCVEnv()}}
\item \code{\link[=autoplot.ResamplingCV]{autoplot.ResamplingCV()}}
\item \code{\link[=autoplot.ResamplingSptCVCstf]{autoplot.ResamplingSptCVCstf()}}
\item \code{\link[=autoplot.ResamplingSptCVCluto]{autoplot.ResamplingSptCVCluto()}}
}
}
