% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingRepeatedSptCVCstf.R
\name{ResamplingRepeatedSptCVCstf}
\alias{ResamplingRepeatedSptCVCstf}
\title{Repeated Spatiotemporal Cluster Resampling}
\description{
Spatiotemporal cluster partitioning via the \code{vcluster} executable of the
CLUTO clustering application.

This partitioning method relies on the external CLUTO library.
To use it, CLUTO's executables need to be downloaded and installed into
this package.

See \url{https://gist.github.com/pat-s/6430470cf817050e27d26c43c0e9be72} for
an installation approach that should work on Windows and Linux. macOS is not
supported by CLUTO.

Before using this method, please check the restrictive copyright shown below.
}
\details{
By default, \code{-clmethod='direct'} is passed to the \code{vcluster} executable in
contrast to the upstream default \code{-clmethod='rb'}.
There is no evidence or research that this method is the best among the
available ones ("rb", "rbr", "direct", "agglo", "graph", "bagglo").
Also, various other parameters can be set via argument \code{cluto_parameters} to
achieve different clustering results.

Parameter \code{-clusterfile} is handled by \CRANpkg{skmeans} and cannot be
changed.
}
\section{Copyright}{


CLUTO's copyright is as follows:

The CLUTO package is copyrighted by the Regents of the University of
Minnesota.
It can be freely used for educational and research purposes by non-profit
institutions and US government agencies only.
Other organizations are allowed to use CLUTO only for evaluation purposes,
and any further uses will require prior approval.
The software may not be sold or redistributed without prior approval.
One may make copies of the software for their use provided that the copies,
are not sold or distributed, are used under the same terms and conditions.
As unestablished research software, this code is provided on an “as is” basis
without warranty of any kind, either expressed or implied.
The downloading, or executing any part of this software constitutes an
implicit agreement to these terms. These terms and conditions are subject to
change at any time without prior notice.
}

\examples{
library(mlr3)
library(mlr3spatiotempcv)
task = tsk("cookfarm")

# Instantiate Resampling
rrcv = rsmp("repeated_sptcv_cstf", folds = 3, repeats = 5, time_var = "Date")
rrcv$instantiate(task)
# Individual sets:
rrcv$iters
rrcv$folds(1:6)
rrcv$repeats(1:6)

# Individual sets:
rrcv$train_set(1)
rrcv$test_set(1)
intersect(rrcv$train_set(1), rrcv$test_set(1))

# Internal storage:
rrcv$instance # table
}
\references{
Zhao Y, Karypis G (2002).
\dQuote{Evaluation of Hierarchical Clustering Algorithms for Document Datasets.}
\emph{11th Conference of Information and Knowledge Management (CIKM)}, 51-524.
\url{http://glaros.dtc.umn.edu/gkhome/node/167}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingRepeatedSptCVCstf}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{space_var}}{\code{character(1)}\cr
Column name identifying the spatial units.}

\item{\code{time_var}}{\code{character(1)}\cr
Column name identifying the temporal units.}

\item{\code{class}}{\code{character(1)}\cr
Column name identifying a class unit (e.g. land cover).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ResamplingRepeatedSptCVCstf$new()}}
\item \href{#method-folds}{\code{ResamplingRepeatedSptCVCstf$folds()}}
\item \href{#method-repeats}{\code{ResamplingRepeatedSptCVCstf$repeats()}}
\item \href{#method-instantiate}{\code{ResamplingRepeatedSptCVCstf$instantiate()}}
\item \href{#method-clone}{\code{ResamplingRepeatedSptCVCstf$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format">}\href{../../mlr3/html/Resampling.html#method-format}{\code{mlr3::Resampling$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help">}\href{../../mlr3/html/Resampling.html#method-help}{\code{mlr3::Resampling$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print">}\href{../../mlr3/html/Resampling.html#method-print}{\code{mlr3::Resampling$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set">}\href{../../mlr3/html/Resampling.html#method-test_set}{\code{mlr3::Resampling$test_set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set">}\href{../../mlr3/html/Resampling.html#method-train_set}{\code{mlr3::Resampling$train_set()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a "Spacetime Folds" resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$new(
  id = "repeated_sptcv_cstf",
  space_var = NULL,
  time_var = NULL,
  class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}

\item{\code{space_var}}{\code{character(1)}\cr
Column name identifying the spatial units.}

\item{\code{time_var}}{\code{character(1)}\cr
Column name identifying the temporal units.}

\item{\code{class}}{\code{character(1)}\cr
Column name identifying a class unit (e.g. land cover).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-folds"></a>}}
\if{latex}{\out{\hypertarget{method-folds}{}}}
\subsection{Method \code{folds()}}{
Translates iteration numbers to fold number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$folds(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-repeats"></a>}}
\if{latex}{\out{\hypertarget{method-repeats}{}}}
\subsection{Method \code{repeats()}}{
Translates iteration numbers to repetition number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$repeats(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
