% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskSurv.R
\name{TaskSurv}
\alias{TaskSurv}
\title{Survival Task}
\description{
This task specializes \link[mlr3:Task]{mlr3::Task} and \link[mlr3:TaskSupervised]{mlr3::TaskSupervised} for possibly-censored survival
problems. The target is comprised of survival times and an event indicator.
Predefined tasks are stored in \link[mlr3:mlr_tasks]{mlr3::mlr_tasks}.

The \code{task_type} is set to \code{"surv"}.
}
\examples{
library(mlr3)
lung = survival::lung
lung$status = (lung$status == 2L)
task = TaskSurv$new("lung",
  backend = lung, time = "time",
  event = "status")

# meta data
task$target_names
task$feature_names
task$formula()

# survival data
task$truth()
task$times()
task$status()
task$unique_times()
task$unique_event_times()
task$risk_set(time = 700)
}
\seealso{
Other Task: 
\code{\link{TaskDens}}
}
\concept{Task}
\section{Super classes}{
\code{\link[mlr3:Task]{mlr3::Task}} -> \code{\link[mlr3:TaskSupervised]{mlr3::TaskSupervised}} -> \code{TaskSurv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{censtype}}{\code{character(1)}\cr
Returns the type of censoring, one of "right", "left", "counting", "interval", or "mstate".}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TaskSurv$new()}}
\item \href{#method-truth}{\code{TaskSurv$truth()}}
\item \href{#method-formula}{\code{TaskSurv$formula()}}
\item \href{#method-times}{\code{TaskSurv$times()}}
\item \href{#method-status}{\code{TaskSurv$status()}}
\item \href{#method-unique_times}{\code{TaskSurv$unique_times()}}
\item \href{#method-unique_event_times}{\code{TaskSurv$unique_event_times()}}
\item \href{#method-risk_set}{\code{TaskSurv$risk_set()}}
\item \href{#method-clone}{\code{TaskSurv$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="add_strata">}\href{../../mlr3/html/Task.html#method-add_strata}{\code{mlr3::Task$add_strata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="cbind">}\href{../../mlr3/html/Task.html#method-cbind}{\code{mlr3::Task$cbind()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="data">}\href{../../mlr3/html/Task.html#method-data}{\code{mlr3::Task$data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="droplevels">}\href{../../mlr3/html/Task.html#method-droplevels}{\code{mlr3::Task$droplevels()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="filter">}\href{../../mlr3/html/Task.html#method-filter}{\code{mlr3::Task$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="format">}\href{../../mlr3/html/Task.html#method-format}{\code{mlr3::Task$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="head">}\href{../../mlr3/html/Task.html#method-head}{\code{mlr3::Task$head()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="help">}\href{../../mlr3/html/Task.html#method-help}{\code{mlr3::Task$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="levels">}\href{../../mlr3/html/Task.html#method-levels}{\code{mlr3::Task$levels()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="missings">}\href{../../mlr3/html/Task.html#method-missings}{\code{mlr3::Task$missings()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="print">}\href{../../mlr3/html/Task.html#method-print}{\code{mlr3::Task$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rbind">}\href{../../mlr3/html/Task.html#method-rbind}{\code{mlr3::Task$rbind()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rename">}\href{../../mlr3/html/Task.html#method-rename}{\code{mlr3::Task$rename()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="select">}\href{../../mlr3/html/Task.html#method-select}{\code{mlr3::Task$select()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_col_roles">}\href{../../mlr3/html/Task.html#method-set_col_roles}{\code{mlr3::Task$set_col_roles()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_row_roles">}\href{../../mlr3/html/Task.html#method-set_row_roles}{\code{mlr3::Task$set_row_roles()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$new(
  id,
  backend,
  time = "time",
  event = "event",
  time2,
  type = c("right", "left", "interval", "counting", "interval2", "mstate")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{backend}}{(\link{DataBackend})\cr
Either a \link{DataBackend}, or any object which is convertible to a \link{DataBackend} with \code{as_data_backend()}.
E.g., a \code{data.frame()} will be converted to a \link{DataBackendDataTable}.}

\item{\code{time}}{(\code{character(1)})\cr
Name of the column for event time if data is right censored, otherwise starting time if
interval censored.}

\item{\code{event}}{(\code{character(1)})\cr
Name of the column giving the event indicator.
If data is right censored then "0"/\code{FALSE} means alive (no event), "1"/\code{TRUE} means dead
(event). If \code{type} is \code{"interval"} then "0" means right censored, "1" means dead (event),
"2" means left censored, and "3" means interval censored. If \code{type} is \code{"interval2"} then
\code{event} is ignored.}

\item{\code{time2}}{(\code{character(1)})\cr
Name of the column for ending time for interval censored data, otherwise ignored.}

\item{\code{type}}{(\code{character(1)})\cr
Name of the column giving the type of censoring. Default is 'right' censoring.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-truth"></a>}}
\if{latex}{\out{\hypertarget{method-truth}{}}}
\subsection{Method \code{truth()}}{
True response for specified \code{row_ids}. Format depends on the task type.
Defaults to all rows with role "use".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$truth(rows = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-formula"></a>}}
\if{latex}{\out{\hypertarget{method-formula}{}}}
\subsection{Method \code{formula()}}{
Creates a formula for survival models with \link[survival:Surv]{survival::Surv} on the LHS.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$formula(rhs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rhs}}{If \code{NULL} RHS is \code{.}, otherwise gives RHS of formula.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-times"></a>}}
\if{latex}{\out{\hypertarget{method-times}{}}}
\subsection{Method \code{times()}}{
Returns the (unsorted) outcome times.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$times(rows = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{numeric()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-status"></a>}}
\if{latex}{\out{\hypertarget{method-status}{}}}
\subsection{Method \code{status()}}{
Returns the event indicator (aka censoring/survival indicator).
If \code{censtype} is \code{"right"} or \code{"left"} then \code{1} is event and \code{0} is censored.
If \code{censtype} is \code{"mstate"} then \code{0} is censored and all other values are different events.
If \code{censtype} is \code{"interval"} then \code{0} is right-censored, \code{1} is event, \code{2} is left-censored,
\code{3} is interval-censored.
See \link[survival:Surv]{survival::Surv}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$status(rows = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{integer()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unique_times"></a>}}
\if{latex}{\out{\hypertarget{method-unique_times}{}}}
\subsection{Method \code{unique_times()}}{
Returns the sorted unique outcome times for 'right', 'left', and 'mcstate'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$unique_times(rows = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{numeric()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unique_event_times"></a>}}
\if{latex}{\out{\hypertarget{method-unique_event_times}{}}}
\subsection{Method \code{unique_event_times()}}{
Returns the sorted unique event (or failure) outcome times.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$unique_event_times(rows = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{numeric()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-risk_set"></a>}}
\if{latex}{\out{\hypertarget{method-risk_set}{}}}
\subsection{Method \code{risk_set()}}{
Returns the \code{row_ids} of the observations 'at risk' (not dead or censored) at \code{time}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$risk_set(time = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{time}}{(\code{numeric(1)}) \cr Time to return risk set for, if \code{NULL} returns all \code{row_ids}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{integer()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
