% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvHarrellC.R
\name{MeasureSurvHarrellC}
\alias{MeasureSurvHarrellC}
\alias{mlr_measures_surv.harrellC}
\title{Harrell's C-Index Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{MeasureSurv}.}
\description{


Calculates Harrell's C, equivalent to the Fortran implementation in \CRANpkg{Hmisc}.
}
\section{Construction}{
\preformatted{MeasureSurvHarrellC$new()
mlr_measures$get("surv.harrellC")
msr("surv.harrellC")
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{crank}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\references{
\cite{mlr3proba}{harrell_1982}
}
\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvMAESE}},
\code{\link{MeasureSurvMAE}},
\code{\link{MeasureSurvMSESE}},
\code{\link{MeasureSurvMSE}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvRMSESE}},
\code{\link{MeasureSurvRMSE}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other Concordance survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvUnoC}}

Other crank survival measures: 
\code{\link{MeasureSurvUnoC}}
}
\concept{Concordance survival measures}
\concept{crank survival measures}
\concept{survival measures}
