% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvGraf.R
\name{MeasureSurvGraf}
\alias{MeasureSurvGraf}
\alias{mlr_measures_surv.graf}
\alias{MeasureSurvBrier}
\alias{mlr_measures_surv.brier}
\title{Integrated Graf Score Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \code{MeasureSurvIntegrated}/\link{MeasureSurv}.}
\description{


Calculates the Integrated Graf Score, aka integrated Brier score or squared loss.

For an individual who dies at time \eqn{t}, with predicted Survival function, \eqn{S}, the
Graf Score at time \eqn{t^*}{t*} is given by
\deqn{L(S,t|t^*) = [(S(t^*)^2)I(t \le t^*, \delta = 1)(1/G(t))] + [((1 - S(t^*))^2)I(t > t^*)(1/G(t^*))]}{L(S,t|t*) = [(S(t*)^2)I(t \le t*, \delta = 1)(1/G(t))] + [((1 - S(t*))^2)I(t > t*)(1/G(t*))]}
where \eqn{G} is the Kaplan-Meier estimate of the censoring distribution.

Note: If comparing the integrated graf score to other packages, e.g. \code{\link[pec:pec]{pec::pec()}}, then
\code{method = 2} should be used, however the results may still be very slightly different as
this package uses \code{survfit} to estimate the censoring distribution, in line with the Graf 1999 paper.
Whereas some other packages use \code{prodlim} with \code{reverse = TRUE} (meaning Kaplan-Meier is not used).

If \code{integrated == FALSE} then the sample mean is taken for the single specified \code{times}, \eqn{t^*}{t*}, and the returned
score is given by
\deqn{L(S,t|t^*) = \frac{1}{N} \sum_{i=1}^N L(S_i,t_i|t^*)}{L(S,t|t*) = 1/N \sum_i^N L(S_i,t_i|t*)}
where \eqn{N} is the number of observations, \eqn{S_i} is the predicted survival function for
individual \eqn{i} and \eqn{t_i} is their true survival time.

If \code{integrated == TRUE} then an approximation to integration is made by taking the mean over all
\eqn{T} unique time-points, and then the sample mean over all \eqn{N} observations.
\deqn{L(S) = \frac{1}{NT} \sum_{i=1}^N \sum_{j=1}^T L(S_i,t_i|t^*_j)}{L(S) = 1/(NT) \sum_i^N \sum_j^T L(S_i,t_i|t*_j)}
}
\section{Construction}{
\preformatted{MeasureSurvGraf$new(integrated = TRUE, times, method = 2)
mlr_measures$get("surv.graf")
msr("surv.graf")
}
\itemize{
\item \code{integrated} :: \code{logical(1)} \cr If \code{TRUE} (default), returns the integrated score; otherwise, not integrated. \cr
\item \code{times} :: \code{vector()} \cr If \code{integrate == TRUE} then a vector of time-points over which to integrate the score. If \code{integrate == FALSE} then a single time point at which to return the score. \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{distr}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\references{
\cite{mlr3proba}{graf_1999}
}
\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvMAESE}},
\code{\link{MeasureSurvMAE}},
\code{\link{MeasureSurvMSESE}},
\code{\link{MeasureSurvMSE}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvRMSESE}},
\code{\link{MeasureSurvRMSE}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other Probabilistic survival measures: 
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}}

Other distr survival measures: 
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}}
}
\concept{Probabilistic survival measures}
\concept{distr survival measures}
\concept{survival measures}
