% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crankcompositor.R
\name{crankcompositor}
\alias{crankcompositor}
\title{Compose a Crank Predict Type for Survival Learners}
\usage{
crankcompositor(
  learner,
  method = c("mean", "median", "mode"),
  param_vals = list()
)
}
\arguments{
\item{learner}{\link{LearnerSurv} object for which a \code{crank} is composed (or over-written)}

\item{method}{One of \code{mean}, \code{mode}, or \code{median}; abbreviations allowed. Used to determine
how \code{crank} is estimated from the predicted \code{distr}. Default is \code{mean}.}

\item{param_vals}{Additional parameters to pass to the \code{learner}.}
}
\value{
\link[mlr3pipelines:GraphLearner]{mlr3pipelines::GraphLearner}
}
\description{
This is a wrapper around the \link{PipeOpCrankCompositor} pipe operation, which
simplifies graph creation.
}
\details{
For full details see \link{PipeOpCrankCompositor}.
}
\examples{
library(mlr3)
library(mlr3pipelines)

task = tgen("simsurv")$generate(20)
ranger.crank = crankcompositor(learner = lrn("surv.coxph"),
                            method = "median")
resample(task, ranger.crank, rsmp("cv", folds = 2))$predictions()
}
