% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_srho.R
\name{srho}
\alias{srho}
\title{Spearman's rho}
\usage{
srho(truth, response, ...)
}
\arguments{
\item{truth}{:: \code{numeric()}\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{:: \code{numeric()}\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Regression measures defined as Spearman's rank correlation coefficient between truth and response.
Calls \code{\link[stats:cor]{stats::cor()}} with \code{method} set to \code{"spearman"}.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{[-1, 1]}{[-1, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
srho(truth, response)
}
\references{
Rosset S, Perlich C, Zadrozny B (2006).
\dQuote{Ranking-based evaluation of regression models.}
\emph{Knowledge and Information Systems}, \bold{12}(3), 331--353.
\doi{10.1007/s10115-006-0037-3}.
}
\seealso{
Other Regression Measures: 
\code{\link{bias}()},
\code{\link{ktau}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{mse}()},
\code{\link{msle}()},
\code{\link{pbias}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{smape}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
