% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifCVGlmnet.R
\name{mlr_learners_classif.cv_glmnet}
\alias{mlr_learners_classif.cv_glmnet}
\alias{LearnerClassifCVGlmnet}
\title{GLM with Elastic Net Regularization Classification Learner}
\description{
Generalized linear models with elastic net regularization.
Calls \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}} from package \CRANpkg{glmnet}.

The default for hyperparameter \code{family} is set to \code{"binomial"} or \code{"multinomial"},
depending on the number of classes.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("classif.cv_glmnet")
lrn("classif.cv_glmnet")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

, * Task type: \dQuote{classif}, * Predict Types: \dQuote{response}, \dQuote{prob}, * Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, * Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{glmnet}
}

\section{Parameters}{

, |Id                   |Type      |Default    |Levels                         |Range                                |, |:--------------------|:---------|:----------|:------------------------------|:------------------------------------|, |alignment            |character |lambda     |lambda, fraction               |-                                    |, |alpha                |numeric   |1          |                               |\eqn{[0, 1]}{[0, 1]}                 |, |big                  |numeric   |9.9e+35    |                               |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |devmax               |numeric   |0.999      |                               |\eqn{[0, 1]}{[0, 1]}                 |, |dfmax                |integer   |-          |                               |\eqn{[0, \infty)}{[0, Inf)}          |, |epsnr                |numeric   |1e-08      |                               |\eqn{[0, 1]}{[0, 1]}                 |, |eps                  |numeric   |1e-06      |                               |\eqn{[0, 1]}{[0, 1]}                 |, |exclude              |integer   |-          |                               |\eqn{[1, \infty)}{[1, Inf)}          |, |exmx                 |numeric   |250        |                               |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |fdev                 |numeric   |1e-05      |                               |\eqn{[0, 1]}{[0, 1]}                 |, |foldid               |untyped   |           |                               |-                                    |, |gamma                |untyped   |-          |                               |-                                    |, |grouped              |logical   |TRUE       |TRUE, FALSE                    |-                                    |, |intercept            |logical   |TRUE       |TRUE, FALSE                    |-                                    |, |keep                 |logical   |FALSE      |TRUE, FALSE                    |-                                    |, |lambda.min.ratio     |numeric   |-          |                               |\eqn{[0, 1]}{[0, 1]}                 |, |lambda               |untyped   |-          |                               |-                                    |, |lower.limits         |untyped   |-          |                               |-                                    |, |maxit                |integer   |100000     |                               |\eqn{[1, \infty)}{[1, Inf)}          |, |mnlam                |integer   |5          |                               |\eqn{[1, \infty)}{[1, Inf)}          |, |mxitnr               |integer   |25         |                               |\eqn{[1, \infty)}{[1, Inf)}          |, |mxit                 |integer   |100        |                               |\eqn{[1, \infty)}{[1, Inf)}          |, |nfolds               |integer   |10         |                               |\eqn{[3, \infty)}{[3, Inf)}          |, |nlambda              |integer   |100        |                               |\eqn{[1, \infty)}{[1, Inf)}          |, |offset               |untyped   |           |                               |-                                    |, |parallel             |logical   |FALSE      |TRUE, FALSE                    |-                                    |, |penalty.factor       |untyped   |-          |                               |-                                    |, |pmax                 |integer   |-          |                               |\eqn{[0, \infty)}{[0, Inf)}          |, |pmin                 |numeric   |1e-09      |                               |\eqn{[0, 1]}{[0, 1]}                 |, |prec                 |numeric   |1e-10      |                               |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |predict.gamma        |numeric   |gamma.1se  |                               |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |relax                |logical   |FALSE      |TRUE, FALSE                    |-                                    |, |s                    |numeric   |lambda.1se |                               |\eqn{[0, \infty)}{[0, Inf)}          |, |standardize          |logical   |TRUE       |TRUE, FALSE                    |-                                    |, |standardize.response |logical   |FALSE      |TRUE, FALSE                    |-                                    |, |thresh               |numeric   |1e-07      |                               |\eqn{[0, \infty)}{[0, Inf)}          |, |trace.it             |integer   |0          |                               |\eqn{[0, 1]}{[0, 1]}                 |, |type.gaussian        |character |-          |covariance, naive              |-                                    |, |type.logistic        |character |-          |Newton, modified.Newton        |-                                    |, |type.measure         |character |deviance   |deviance, class, auc, mse, mae |-                                    |, |type.multinomial     |character |-          |ungrouped, grouped             |-                                    |, |upper.limits         |untyped   |-          |                               |-                                    |
}

\section{Internal Encoding}{

Starting with \CRANpkg{mlr3} v0.5.0, the order of class labels is reversed prior to
model fitting to comply to the \code{\link[stats:glm]{stats::glm()}} convention that the negative class is provided
as the first factor level.
}

\examples{
if (requireNamespace("glmnet", quietly = TRUE)) {
  learner = mlr3::lrn("classif.cv_glmnet")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Friedman J, Hastie T, Tibshirani R (2010).
\dQuote{Regularization Paths for Generalized Linear Models via Coordinate Descent.}
\emph{Journal of Statistical Software}, \bold{33}(1), 1--22.
\doi{10.18637/jss.v033.i01}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}} -> \code{LearnerClassifCVGlmnet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClassifCVGlmnet-new}{\code{LearnerClassifCVGlmnet$new()}}
\item \href{#method-LearnerClassifCVGlmnet-selected_features}{\code{LearnerClassifCVGlmnet$selected_features()}}
\item \href{#method-LearnerClassifCVGlmnet-clone}{\code{LearnerClassifCVGlmnet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifCVGlmnet-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifCVGlmnet-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifCVGlmnet$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifCVGlmnet-selected_features"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifCVGlmnet-selected_features}{}}}
\subsection{Method \code{selected_features()}}{
Returns the set of selected features as reported by \code{\link[glmnet:predict.glmnet]{glmnet::predict.glmnet()}}
with \code{type} set to \code{"nonzero"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifCVGlmnet$selected_features(lambda = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lambda}}{(\code{numeric(1)})\cr
Custom \code{lambda}, defaults to the active lambda depending on parameter set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character()}) of feature names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifCVGlmnet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifCVGlmnet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifCVGlmnet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
