#' @importFrom utils bibentry
bibentries = c(
  bossek_2017 = bibentry("inproceedings",
    doi         = "10.1145/3067695.3082470",
    year        = "2017",
    month       = "jul",
    publisher   = "ACM",
    author      = "Jakob Bossek",
    title       = "ecr 2.0",
    booktitle   = "Proceedings of the Genetic and Evolutionary Computation Conference Companion"
  ),

  bergstra_2012 = bibentry("article",
    title       = "Random Search for Hyper-Parameter Optimization",
    author      = "James Bergstra and Yoshua Bengio",
    year        = "2012",
    journal     = "Journal of Machine Learning Research",
    volume      = "13",
    number      = "10",
    pages       = "281--305",
    url         = "https://jmlr.csail.mit.edu/papers/v13/bergstra12a.html"
  ),

  thomas2017  = bibentry("article",
    doi       = "10.1155/2017/1421409",
    year      = "2017",
    publisher = "Hindawi Limited",
    volume    = "2017",
    pages     = "1--8",
    author    = "Janek Thomas and Tobias Hepp and Andreas Mayr and Bernd Bischl",
    title     = "Probing for Sparse and Fast Variable Selection with Model-Based Boosting",
    journal   = "Computational and Mathematical Methods in Medicine"
  ),

  wu2007      = bibentry("article",
    doi       = "10.1198/016214506000000843",
    year      = "2007",
    month     = "3",
    publisher = "Informa {UK} Limited",
    volume    = "102",
    number    = "477",
    pages     = "235--243",
    author    = "Yujun Wu and Dennis D Boos and Leonard A Stefanski",
    title     = "Controlling Variable Selection by the Addition of Pseudovariables",
    journal   = "Journal of the American Statistical Association"
  )
)
