% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterCMIM.R
\docType{data}
\name{FilterCMIM}
\alias{FilterCMIM}
\alias{mlr_filters_cmim}
\title{Minimal Conditional Mutual Information Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Minimal conditional mutual information maximisation filter
calling \code{\link[praznik:CMIM]{praznik::CMIM()}} from package \CRANpkg{praznik}.

This filter supports partial scoring (see \link{Filter}).
}
\section{Construction}{
\preformatted{FilterCMIM$new()
mlr_filters$get("cmim")
flt("cmim")
}
}

\examples{
task = mlr3::tsk("iris")
filter = flt("cmim")
filter$calculate(task, nfeat = 2)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCarScore}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterDISR}}, \code{\link{FilterImportance}},
  \code{\link{FilterInformationGain}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}}, \code{\link{FilterMIM}},
  \code{\link{FilterMRMR}}, \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{Filter}},
  \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
