% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_prediction.R
\name{as_prediction}
\alias{as_prediction}
\alias{as_prediction.Prediction}
\alias{as_prediction.PredictionDataClassif}
\alias{as_prediction.PredictionDataRegr}
\alias{as_predictions}
\alias{as_predictions.list}
\title{Convert to a Prediction}
\usage{
as_prediction(x, check = TRUE, ...)

\method{as_prediction}{Prediction}(x, check = TRUE, ...)

\method{as_prediction}{PredictionDataClassif}(x, check = TRUE, ...)

\method{as_prediction}{PredictionDataRegr}(x, check = TRUE, ...)

as_predictions(x, predict_sets = "test", ...)

\method{as_predictions}{list}(x, predict_sets = "test", ...)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{check}{(\code{logical(1)})\cr
Perform argument checks and type conversions?}

\item{...}{(any)\cr
Additional arguments.}

\item{predict_sets}{(\code{character()})\cr
Prediction sets to operate on, used in \code{aggregate()} to extract the matching \code{predict_sets} from the \link{ResampleResult}.
Multiple predict sets are calculated by the respective \link{Learner} during \code{\link[=resample]{resample()}}/\code{\link[=benchmark]{benchmark()}}.
Must be a non-empty subset of \verb{\{"train", "test", "validation"\}}.
If multiple sets are provided, these are first combined to a single prediction object.
Default is \code{"test"}.}
}
\value{
\link{Prediction}.
}
\description{
Convert object to a \link{Prediction} or a list of \link{Prediction}.
}
