% Generated by roxygen2 (4.0.2): do not edit by hand
\name{setHyperPars}
\alias{setHyperPars}
\title{Set the hyperparameters of a learner object.}
\usage{
setHyperPars(learner, ..., par.vals = list())
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{...}{[any]\cr
Named (hyper)parameters with new setting. Alternatively these can be passed
using the \code{par.vals} argument.}

\item{par.vals}{[\code{list}]\cr
Optional list of named (hyper)parameter settings. The arguments in
\code{...} take precedence over values in this list.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Set the hyperparameters of a learner object.
}
\examples{
cl1 = makeLearner("classif.ksvm", sigma = 1)
cl2 = setHyperPars(cl1, sigma = 10, par.vals = list(C = 2))
print(cl1)
# note the now set and altered hyperparameters:
print(cl2)
}
\seealso{
Other learner: \code{\link{getHyperPars}};
  \code{\link{getParamSet}}; \code{\link{removeHyperPars}};
  \code{\link{setId}}; \code{\link{setPredictType}};
  \code{\link{showHyperPars}}
}

