% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeWeightedClassesWrapper}
\alias{makeWeightedClassesWrapper}
\title{Wraps a classifier for weighted fitting where each class receives a weight.}
\usage{
makeWeightedClassesWrapper(learner, wcw.weight)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The classification learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{wcw.weight}{[\code{numeric}]\cr
Weight for each class.
Must be a vector of the same number of elements as classes are in task,
and must also be in the same order as the class levels are in
\code{task$task.desc$class.levels}.
For convenience, one must pass a single number in case of binary classification, which
is then taken as the weight of the positive class, while the negative class receives a weight
of 1.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Creates a wrapper, which can be used like any other learner object.

Fitting is performed in a weighted fashion where each observation receives a weight,
depending on the class is belongs to, see \code{wcw.weight}.
This might help to mitigate problems in imbalanced classification problems.
}

