% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_pca.R
\encoding{UTF-8}
\name{dis_pca}
\alias{dis_pca}
\title{Constructs a pairwise distance matrix based on Principal Component Analysis (PCA)}
\usage{
dis_pca(X, retained_components = 3)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{retained_components}{Number of retained principal components.}
}
\value{
The computed pairwise distance matrix.
}
\description{
\code{dis_eros} returns a pairwise distance matrix based on the
PCA similarity factor proposed by \insertCite{singhal2005clustering;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T} is defined
as \eqn{d_{PCA}(\boldsymbol X_{T}, \boldsymbol Y_{T})=1-S_{PCA}
(\boldsymbol X_{T}, \boldsymbol Y_{T})}, with
\deqn{S_{PCA}(\boldsymbol X_{T}, \boldsymbol Y_{T})=\frac{\sum_{i=1}^{k}\sum_{j=1}^{k}
(\lambda^i_{\boldsymbol X_T}
\lambda^j_{\boldsymbol Y_T})\cos^2 \theta_{ij}}{\sum_{i=1}^{k}
\lambda^i_{\boldsymbol X_T} \lambda^i_{\boldsymbol Y_T}},}
where \eqn{\theta_{ij}} is the angle between the \eqn{i}th eigenvector of
\eqn{\boldsymbol X_{T}} and the \eqn{j}th eigenvector of series \eqn{\boldsymbol Y_{T}},
respectively, and \eqn{\lambda^i_{\boldsymbol Y_T}} and \eqn{\lambda^i_{\boldsymbol Y_T}}
are the \eqn{i}th eigenvalues of \eqn{\boldsymbol X_{T}} and the
\eqn{j}th eigenvalues of series \eqn{\boldsymbol Y_{T}} respectively.
}
\examples{
toy_dataset <- BasicMotions$data[1 : 10] # Selecting the first 10 MTS from the
# dataset BasicMotions
distance_matrix <- dis_pca(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_pca
}
\references{
{

  \insertRef{singhal2005clustering}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
