% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.r
\name{manhattan.plot}
\alias{manhattan.plot}
\title{Manhattan plot}
\usage{
manhattan.plot(res.mlmm, map = NULL, steps = 1, hideCofactors = FALSE,
  chrToPlot = "all", unit = "cM", ...)
}
\arguments{
\item{res.mlmm}{Output object from \code{\link{mlmm_allmodels}}.}

\item{map}{Dataframe with 3 columns : markers names, chromosome or scaffold names and position (any unit is allowed: cM, Mpb etc.).}

\item{steps}{An integer. The iteration number of the forward approach. If a vector of length >= 2 is passed, several plots will be drawn. By default, only step 1 is drawn.}

\item{hideCofactors}{If TRUE, the coffactors (fixed effects) won't be drawn}

\item{chrToPlot}{Names of the chromosomes or scaffolds to plot. Use this if you want to zoom on a particular chromosome.}

\item{unit}{Unit of the positions in the map.}

\item{...}{additional arguments can be passed to the plot function.}
}
\description{
Draw a Manhattan plot of the association p-values of the markers.
}
\details{
Draws a manhattan plot ie. plot -log(p-value) vs marker position

If a map is passed, markers position will be used as x axis.
If not, the indices of markers inside the res.mlmm object will be used instead

If there are cofactors (as in all but the first step of the forward approch),
the cofactors markers will be plotted too (symbol: star).

If a map is passed, markers not in the map or in the map but not assigned to a chromosome
will be assigned to a virtual chromosome 0.

Markers in the map, assigned to a chromosome, but with missing position, will be
ploted at the end of the chromosome.
}
\examples{
### Additive model ###
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa)
KK = list(K.add)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))

# Effects estimations with the selected model
sel_XXclass <- fromeBICtoEstimation(XX, res.eBIC)
eff.estimations <- Estimation_allmodels(floweringDateAD, sel_XXclass, KK)
genotypes.boxplot(Xa, floweringDateAD, effects = eff.estimations)
}

### Additive + dominance model
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa, Xd)
KK = list(K.add, K.dom)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))
#the selected model is the null model
}


### Female+Male model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm)
KK = list(K.female, K.male)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}



### Female+Male+Interaction model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm, Xfm)
KK = list(K.female, K.male, K.hybrid)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}
}
\seealso{
\code{\link{mlmm_allmodels}}
}
