% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{write.mldr}
\alias{write.mldr}
\title{Export an mldr object or set of mldr objects to different file formats}
\usage{
write.mldr(mld, format = c("MULAN", "MEKA"), sparse = FALSE,
  basename = ifelse(!is.null(mld$name) && nchar(mld$name) > 0,
  regmatches(mld$name, regexpr("(\\\\w)+", mld$name)), "unnamed_mldr"))
}
\arguments{
\item{mld}{The \code{mldr/mldr.folds} object to be exported}

\item{format}{A vector of strings stating the desired file formats. It can contain the values \code{'MULAN'}, \code{'MEKA'},
\code{'KEEL'}, \code{'CSV'} and \code{'LIBSVM'}}

\item{sparse}{Boolean value indicating if sparse representation has to be used for ARFF-based file formats}

\item{basename}{Base name for the files. \code{'unnamed_mldr'} is used by default}
}
\description{
Writes one or more files in the specified formats with the content of the \code{mldr} or \code{mldr.folds} given as parameter
}
\examples{
\dontrun{
library(mldr.datasets)
write.mldr(emotions, format = c('CSV', 'KEEL'))
}
}

