% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getERepro}
\alias{getERepro}
\title{Get energy rate available for reproduction}
\usage{
getERepro(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  t = 0,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{...}{Unused}
}
\value{
A two dimensional array (prey species x prey size) holding
\deqn{\psi_i(w)E_{r.i}(w)}
where \eqn{E_{r.i}(w)} is the rate at which energy becomes available for
growth and reproduction, calculated with \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}},
and \eqn{\psi_i(w)} is the proportion of this energy that is used for
reproduction. This proportion is taken from the \code{params} object and is
set with \code{\link[=setReproduction]{setReproduction()}}.
}
\description{
Calculates the energy rate (grams/year) available for reproduction after
growth and metabolism have been accounted for.
}
\section{Your own reproduction rate function}{

By default \code{\link[=getERepro]{getERepro()}} calls \code{\link[=mizerERepro]{mizerERepro()}}. However you can
replace this with your own alternative reproduction rate function. If
your function is called \code{"myERepro"} then you register it in a MizerParams
object \code{params} with

\if{html}{\out{<div class="sourceCode">}}\preformatted{params <- setRateFunction(params, "ERepro", "myERepro")
}\if{html}{\out{</div>}}

Your function will then be called instead of \code{\link[=mizerERepro]{mizerERepro()}}, with the
same arguments.
}

\examples{
\dontrun{
params <- NS_params
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getERepro(params, n = N(sim)[15, , ], n_pp = NResource(sim)[15, ], t = 15)
}
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
