% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerPredMort}
\alias{mizerPredMort}
\title{Get total predation mortality rate needed to project standard mizer model}
\usage{
mizerPredMort(params, n, n_pp, n_other, pred_rate, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{pred_rate}{A two dimensional array (predator species x predator size)
with the feeding level.}

\item{...}{Optional arguments for rate functions.}
}
\value{
A two dimensional array (prey species x prey size) with the predation
mortality
}
\description{
Calculates the total predation mortality rate \eqn{\mu_{p,i}(w_p)} (in units
of 1/year) on each prey species by prey size:
\deqn{\mu_{p.i}(w_p) = \sum_j {\tt pred\_rate}_j(w_p)\, \theta_{ji}.}{
  \mu_{p.i}(w_p) = \sum_j pred_rate_j(w_p) \theta_{ji}.}
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
