% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getEReproAndGrowth}
\alias{getEReproAndGrowth}
\alias{getEReproAndGrowth,MizerParams,matrix,numeric,matrix-method}
\alias{getEReproAndGrowth,MizerParams,matrix,numeric,missing-method}
\title{getEReproAndGrowth method for the size based model}
\usage{
getEReproAndGrowth(object, n, n_pp, feeding_level)

\S4method{getEReproAndGrowth}{MizerParams,matrix,numeric,matrix}(object, n,
  n_pp, feeding_level)

\S4method{getEReproAndGrowth}{MizerParams,matrix,numeric,missing}(object, n,
  n_pp)
}
\arguments{
\item{object}{A \code{MizerParams} object.}

\item{n}{A matrix of species abundance (species x size).}

\item{n_pp}{A vector of the background abundance by size.}

\item{feeding_level}{The current feeding level (optional). A matrix of size
no. species x no. size bins. If not supplied, is calculated internally
using the \code{getFeedingLevel()} method.}
}
\value{
A two dimensional array (species x size)
}
\description{
Calculates the energy rate available by species and size for reproduction and
growth after metabolism and movement have been accounted for: \eqn{E_{r.i}(w)}.
Used by the \code{project} method for performing simulations.

\code{getEReproAndGrowth} method with \code{feeding_level} argument.

\code{getEReproAndGrowth} method without \code{feeding_level} argument.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getEReproAndGrowth(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
\code{\link{project}} and \code{\link{getFeedingLevel}}.
}
