\docType{methods}
\name{MizerParams}
\alias{MizerParams}
\alias{MizerParams,data.frame,matrix-method}
\alias{MizerParams,data.frame,missing-method}
\alias{MizerParams,numeric,missing-method}
\alias{MizerParams-method}
\title{Constructors for objects of \code{MizerParams} class}
\arguments{
  \item{object}{A data frame of species specific parameter
  values (see notes below).}

  \item{interaction}{Optional argument to specify the
  interaction matrix of the species (predator by prey). If
  missing a default interaction is used where all
  interactions between species are set to 1. Note that any
  dimnames of the interaction matrix argument are ignored
  by the constructor. The dimnames of the interaction
  matrix in the returned \code{MizerParams} object are
  taken from the species names in the \code{species_params}
  slot. This means that the order of the columns and rows
  of the interaction matrix argument should be the same as
  the species name in the \code{species_params} slot.}

  \item{...}{Additional arguments used to specify the
  dimensions and sizes of the model. These include:

  \itemize{ \item{\code{min_w} The smallest size of the
  community spectrum} \item{\code{max_w} The largest size
  of the community spectrum. Default value is the largest
  w_inf in the community x 1.1} \item{\code{no_w} The
  number of size bins in the community spectrum}
  \item{\code{min_w_pp} The smallest size of the background
  spectrum} \item{\code{no_w_pp} The number of the extra
  size bins in the background spectrum (i.e. the difference
  between the number of sizes bins in the community
  spectrum and the full spectrum)} \item{\code{n} Scaling
  of the intake. Default value is 2/3} \item{\code{p}
  Scaling of the standard metabolism. Default value is 0.7}
  \item{\code{q} Exponent of the search volume. Default
  value is 0.8} \item{\code{r_pp} Growth rate of the
  primary productivity. Default value is 10}
  \item{\code{kappa} Carrying capacity of the resource
  spectrum. Default value is 1e11} \item{\code{lambda}
  Exponent of the resource spectrum. Default value is
  (2+q-n)} \item{\code{w_pp_cutoff} The cut off size of the
  background spectrum. Default value is 10} \item{\code{f0}
  Average feeding level. Used to calculated \code{h} and
  \code{gamma} if those are not columns in the species data
  frame. Also requires \code{k_vb} (the von Bertalanffy K
  parameter) to be a column in the species data frame. If
  \code{h} and \code{gamma} are supplied then this argument
  is ignored. Default is 0.6.} \item{\code{z0pre} If
  \code{z0}, the mortality from other sources, is not a
  column in the species data frame, it is calculated as
  z0pre * w_inf ^ z0exp. Default value is 0.6.}
  \item{\code{z0exp} If \code{z0}, the mortality from other
  sources, is not a column in the species data frame, it is
  calculated as z0pre * w_inf ^ z0exp. Default value is
  n-1.} }}
}
\value{
  An object of type \code{MizerParams}
}
\description{
  Constructor method for the \code{\link{MizerParams}}
  class. Provides the simplest way of making a
  \code{MizerParams} object to be used in a simulation.
}
\note{
  The only essential argument to the \code{MizerParams}
  constructor is a data frame which contains the species
  data. The data frame is arranged species by parameter, so
  each column of the parameter data frame is a parameter
  and each row has the parameters for one of the species in
  the model.

  There are some essential columns that must be included in
  the parameter data.frame and that do not have default
  values. Other columns do have default values, so that if
  they are not included in the species parameter data
  frame, they will be automatically added when the
  \code{MizerParams} object is created. See the
  accompanying vignette for details of these columns.

  An additional constructor method which takes an integer
  of the number of species in the model. This is only used
  in internally to set up a \code{MizerParams} object with
  the correct dimensions. It is not recommended that this
  method is used by users.
}
\examples{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
}
\seealso{
  \code{\link{project}} \code{\link{MizerSim}}
}

