% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc_trim_cpp.R
\name{trim.vlmc_cpp}
\alias{trim.vlmc_cpp}
\title{This function returns a trimmed VLMC from which match positions have been
removed.}
\usage{
\method{trim}{vlmc_cpp}(ct, ...)
}
\arguments{
\item{ct}{a VLMC.}

\item{...}{additional arguments for the trim function.}
}
\value{
a trimmed VLMC
}
\description{
This function returns a trimmed context tree from which match positions
have been removed.
}
\details{
Trimming in the C++ backend is done directly in the \code{Rcpp} managed memory and
cannot be detected at R level using e.g. \code{\link[utils:object.size]{utils::object.size()}}.
}
\examples{
## VLMC trimming is generally useless unless match positions were kept
pc <- powerconsumption[powerconsumption$week \%in\% 5:6, ]
dts <- cut(pc$active_power, breaks = 4)
model <- vlmc(dts, backend = "C++", keep_match = TRUE)
model <- trim(model)
}
