% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_model_fit}
\alias{plot_model_fit}
\title{Plot model fit against human error data (target errors)}
\usage{
plot_model_fit(
  participant_data,
  model_fit,
  model,
  unit = "degrees",
  id_var = "id",
  response_var = "response",
  target_var = "target",
  set_size_var = NULL,
  condition_var = NULL,
  n_bins = 18,
  n_col = 2,
  palette = "Dark2"
)
}
\arguments{
\item{participant_data}{A data frame of the participant data, with columns
containing: participant identifier ('id_var'); the participants' response
per trial ('response_var'); the target value ('target_var'); and, if
applicable, the set size of each response ('set_size_var'), and the condition
of each response ('condition_var').}

\item{model_fit}{The model fit object to be plotted against participant data.}

\item{model}{A string indicating the model that was fit to the data. Currently
the options are "2_component", "3_component", "slots", and "slots_averaging".}

\item{unit}{The unit of measurement in the data frame: "degrees"
(measurement is in degrees, from 0 to 360); "degrees_180 (measurement is in
degrees, but limited to 0 to 180); or "radians" (measurement is in radians,
from pi to 2 * pi, but could also be already in -pi to pi).}

\item{id_var}{The column name coding for participant id. If the data is from
a single participant (i.e., there is no id column) set to "NULL".}

\item{response_var}{The column name coding for the participants' responses}

\item{target_var}{The column name coding for the target value}

\item{set_size_var}{The column name (if applicable) coding for the set
size of each response}

\item{condition_var}{The column name (if applicable) coding for the
condition of each response}

\item{n_bins}{An integer controlling the number of cells / bins used in the
plot of the behavioural data.}

\item{n_col}{An integer controlling the number of columns in the resulting
plot.}

\item{palette}{A character stating the preferred colour palette to use. To
see all available palettes, type display.brewer.all() into the console.}
}
\value{
The function returns a ggplot2 object visualising the mean observed
response error density distribution across participants (if applicable)
per set-size (if applicable) and condition (if applicable) together with the
model predictions superimposed.
}
\description{
Plot model fit against human error data (target errors)
}
