% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.gsub.R
\name{chr.gsub}
\alias{chr.gsub}
\title{Multiple Pattern Matching And Replacements}
\usage{
chr.gsub(pattern, replacement, x, recycle = FALSE, check = TRUE, ...)
}
\arguments{
\item{pattern}{a character vector with character strings to be matched.}

\item{replacement}{a character vector equal in length to \code{pattern} or of
length one which are a replacement for matched patterns.}

\item{x}{a character vector where matches and replacements are sought.}

\item{recycle}{logical: if \code{TRUE}, replacement is recycled if lengths differ.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{...}{additional arguments to pass to the \code{regexpr} or \code{sub}
function.}
}
\value{
Return a character vector of the same length and with the same attributes as
\code{x} (after possible coercion to character).
}
\description{
This function is a multiple global string replacement wrapper that allows access
to multiple methods of specifying matches and replacements.
}
\note{
This function was adapted from the \code{mgsub()} function in the \pkg{mgsub}
package by Mark Ewing (2019).
}
\examples{
# Example 1: Replace 'the' and 'they' with 'a' and 'we'
chr.vector <- "they don't understand the value of what they seek."
chr.gsub(c("the", "they"), c("a", "we"), chr.vector)

# Example 2: Replace 'heyy' and 'ho' with 'yo'
chr.vector <- c("hey ho, let's go!")
chr.gsub(c("hey", "ho"), "yo", chr.vector, recycle = TRUE)

# Example 3: Replace with regular expressions
chr.vector <- "Dopazamine is not the same as dopachloride or dopastriamine, yet is still fake."
chr.gsub(c("[Dd]opa([^ ]*?mine)","fake"), c("Meta\\1","real"), chr.vector)
}
\references{
Mark Ewing (2019). \emph{mgsub: Safe, Multiple, Simultaneous String Substitution}.
R package version 1.7.1. https://CRAN.R-project.org/package=mgsub
}
\seealso{
\code{\link{chr.color}}, \code{\link{chr.grep}}, \code{\link{chr.grepl}},
\code{\link{chr.omit}}, \code{\link{chr.trim}}, \code{\link{chr.trunc}}
}
\author{
Mark Ewing
}
