% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.satcor.R
\name{na.satcor}
\alias{na.satcor}
\alias{cfa.satcor}
\alias{sem.satcor}
\alias{growth.satcor}
\alias{lavaan.satcor}
\title{Fit a Saturated Correlates Model}
\usage{
na.satcor(model, data, aux, fun = c("cfa", "sem", "growth", "lavaan"),
          check = TRUE, ...)

cfa.satcor(model, data, aux, check = TRUE, ...)

sem.satcor(model, data, aux, check = TRUE, ...)

growth.satcor(model, data, aux, check = TRUE, ...)

lavaan.satcor(model, data, aux, check = TRUE, ...)
}
\arguments{
\item{model}{a character string indicating the lavaan model syntax without the
auxiliary variables specified in \code{aux}.}

\item{data}{a data frame containing the observed variables used in the lavaan
model syntax specified in \code{model} and the auxiliary variables
specified in \code{aux}.}

\item{aux}{a character vector indicating the names of the auxiliary variables
in the data frame specified in \code{data} that will be added to
the lavaan model syntax specified in \code{model}. Note that
this function can only incorporate continuous auxiliary variables,
i.e., the function cannot deal with categorical auxiliary variables.}

\item{fun}{a character string indicating the name of a specific lavaan function
used to fit \code{model}, i.e., \code{cfa}, \code{sem}, \code{growth},
or \code{lavaan}. Note that this argument is only required for
the function \code{na.satcor}.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}
\item{...}{additional arguments passed to the lavaan function.}
}
\value{
An object of class lavaan, for which several methods are available in the
R package \pkg{lavaan}, including  a summary method.
}
\description{
This function estimates a confirmatory factor analysis model (\code{cfa.satcor}
function), structural equation model (\code{sem.satcor} function), growth curve
model (\code{growth.satcor} function), or latent variable model (\code{lavaan.satcor}
function) in the R package \pkg{lavaan} using full information maximum likelihood
(FIML) method to handle missing data while automatically specifying a saturated
correlates model to incorporate auxiliary variables into a substantive model
without affecting the parameter estimates, the standard errors, or the estimates
of quality of fit (Graham, 2003).
}
\note{
This function is a modified copy of the \code{auxiliary()}, \code{cfa.auxiliary()},
\code{sem.auxiliary()}, \code{growth.auxiliary()}, and \code{lavaan.auxiliary()}
functions in the \pkg{semTools} package by Terrence D. Jorgensen et al.
(2022).
}
\examples{
\dontrun{
# Load lavaan package
library(lavaan)

#----------------------------------------------------------------------------
# Example 1: Saturated correlates model for the sem function

# Model specification
model <- 'Ozone ~ Wind'

# Model estimation using the sem.satcor function
mod.fit <- sem.satcor(model, data = airquality, aux = c("Temp", "Month"))

# Model estimation using the na.satcor function
mod.fit <- na.satcor(model, data = airquality, fun = "sem", aux = c("Temp", "Month"),
                     estimator = "MLR")

# Result summary
summary(mod.fit)
}
}
\references{
Graham, J. W. (2003). Adding missing-data-relevant variables to FIML-based
structural equation models. \emph{Structural Equation Modeling, 10}(1), 80-100.
https://doi.org/10.1207/S15328007SEM1001_4

Jorgensen, T. D., Pornprasertmanit, S., Schoemann, A. M., & Rosseel, Y. (2022).
\emph{semTools: Useful tools for structural equation modeling}. R package version
0.5-6. Retrieved from https://CRAN.R-project.org/package=semTools
}
\author{
Takuya Yanagida
}
