% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect.R
\name{indirect}
\alias{indirect}
\title{Confidence Intervals for the Indirect Effect}
\usage{
indirect(a, b, se.a, se.b, print = c("all", "asymp", "dop", "mc"),
         se = c("sobel", "aroian", "goodman"), nrep = 100000,
         alternative = c("two.sided", "less", "greater"),
         seed = NULL, conf.level = 0.95, digits = 3, check = TRUE,
         output = TRUE)
}
\arguments{
\item{a}{a numeric value indicating the coefficient \eqn{a}, i.e.,
effect of \eqn{X} on \eqn{M}.}

\item{b}{a numeric value indicating the coefficient \eqn{b}, i.e.,
effect of \eqn{M} on \eqn{Y} adjusted for \eqn{X}.}

\item{se.a}{a positive numeric value indicating the standard error of
\eqn{a}.}

\item{se.b}{a positive numeric value indicating the standard error of
\eqn{b}.}

\item{print}{a character string or character vector indicating which confidence
intervals (CI) to show on the console, i.e. \code{"all"} for all
CIs, \code{"asymp"} for the CI based on the asymptotic normal
method, \code{"dop"} (default) for the CI based on the distribution
of the product method, and \code{"mc"} for the CI based on the Monte
Carlo method.}

\item{se}{a character string indicating which standard error (SE) to compute
for the asymptotic normal method, i.e., \code{"sobel"} for the
approximate standard error by Sobel (1982) using the multivariate
delta method based on a first order Taylor series approximation,
\code{"aroian"} (default) for the exact standard error by
Aroian (1947) based on a first and second order Taylor series
approximation, and \code{"goodman"} for the unbiased standard
error by Goodman (1960).}

\item{nrep}{an integer value indicating the number of Monte Carlo repetitions.}

\item{alternative}{a character string specifying the alternative hypothesis, must be
one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{seed}{a numeric value specifying the seed of the random number generator
when using the Monte Carlo method.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level
of the interval.}

\item{digits}{an integer value indicating the number of decimal places
to be used for displaying}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis (\code{type}), list with the input specified in \code{a}
\code{b}, \code{se.a}, and \code{se.b} (\code{data}), specification of function arguments (\code{args}),
and a list with the result tables (\code{result}).
}
\description{
This function computes confidence intervals for the indirect effect based on the
asymptotic normal method, distribution of the product method and the Monte Carlo
method. By default, the function uses the distribution of the product method
for computing the two-sided 95\% asymmetric confidence intervals for the indirect
effect product of coefficient estimator \eqn{\hat{a}\hat{b}}.
}
\details{
In statistical mediation analysis (MacKinnon & Tofighi, 2013), the indirect effect
refers to the effect of the independent variable \eqn{X} on the outcome variable
\eqn{Y} transmitted by the mediator variable \eqn{M}. The magnitude of the indirect
effect \eqn{ab} is quantified by the product of the the coefficient \eqn{a}
(i.e., effect of \eqn{X} on \eqn{M}) and the coefficient \eqn{b} (i.e., effect of
\eqn{M} on \eqn{Y} adjusted for \eqn{X}). In practice, researchers are often
interested in confidence limit estimation for the indirect effect. This function
offers three different methods for computing the confidence interval for the
product of coefficient estimator \eqn{\hat{a}\hat{b}}:

\strong{(1) Asymptotic normal method}

In the asymptotic normal method, the standard error for the product of the
coefficient estimator \eqn{\hat{a}\hat{b}} is computed which is used to create
a symmetrical confidence interval based on the z-value of the standard normal
(\eqn{z}) distribution assuming that the indirect effect is normally distributed.
Note that the function provides three formulas for computing the standard error
by specifying the argument \code{se}:

\describe{
  \item{\code{"sobel"}}{Approximate standard error by Sobel (1982) using the
  multivariate delta method based on a first order Taylor series approximation:
  \deqn{\sqrt(a^2 \sigma^2_a + b^2 \sigma^2_b)}}

  \item{\code{"aroian"}}{Exact standard error by Aroian (1947) based on a first
  and second order Taylor series approximation:
  \deqn{\sqrt(a^2 \sigma^2_a + b^2 \sigma^2_b + \sigma^2_a \sigma^2_b)}}

  \item{\code{"goodman"}}{Unbiased standard error by Goodman (1960):
  \deqn{\sqrt(a^2 \sigma^2_a + b^2 \sigma^2_b - \sigma^2_a \sigma^2_b)}
  Note that the unbiased standard error is often negative and is hence
  undefined for zero or small effects or small sample sizes.}
}

The asymptotic normal method is known to have low statistical power because
the distribution of the product \eqn{\hat{a}\hat{b}} is not normally distributed.
(Kisbu-Sakarya, MacKinnon, & Miocevic, 2014). In the null case, where both random
variables have mean equal to zero, the distribution is symmetric with kurtosis of
six. When the product of the means of the two random variables is nonzero, the
distribution is skewed (up to a maximum value of \eqn{\pm} 1.5) and has a excess
kurtosis (up to a maximum value of 6). However, the product approaches a normal
distribution as one or both of the ratios of the means to standard errors of each
random variable get large in absolute value (MacKinnon, Lockwood & Williams, 2004).

\strong{(2) Distribution of the product method}

The distribution of the product method (MacKinnon et al., 2002) relies on an
analytical approximation of the distribution of the product of two normally
distributed variables. The method uses the standardized \eqn{a} and \eqn{b}
coefficients to compute \eqn{ab} and then uses the critical values for the
distribution of the product (Meeker, Cornwell, & Aroian, 1981) to create
asymmetric confidence intervals. The distribution of the product approaches
the gamma distribution (Aroian, 1947). The analytical solution for the distribution
of the product is provided by the Bessel function used to the solution of
differential equations and is approximately proportional to the Bessel function
of the second kind with a purely imaginary argument (Craig, 1936).

\strong{(3) Monte Carlo method}

The Monte Carlo (MC) method (MacKinnon et al., 2004) relies on the assumption
that the parameters \eqn{a} and \eqn{b} have a joint normal sampling distribution.
Based on the parametric assumption, a sampling distribution of the product
\eqn{a}\eqn{b} using random samples with population values equal to the sample
estimates \eqn{\hat{a}}, \eqn{\hat{b}}, \eqn{\hat{\sigma}_a}, and \eqn{\hat{\sigma}_b}
is generated. Percentiles of the sampling distribution are identified to serve as
limits for a \eqn{100(1 - \alpha)}\% asymmetric confidence interval about the sample
\eqn{\hat{a}\hat{b}} (Preacher & Selig, 2012). Note that parametric assumptions
are invoked for \eqn{\hat{a}} and \eqn{\hat{b}}, but no parametric assumptions
are made about the distribution of \eqn{\hat{a}\hat{b}}.
}
\note{
The function was adapted from the \code{medci()} function in the \pkg{RMediation}
package by Davood Tofighi and David P. MacKinnon (2016).
}
\examples{
# Distribution of the Product Method
indirect(a = 0.35, b = 0.27, se.a = 0.12, se.b = 0.18)

# Monte Carlo Method
indirect(a = 0.35, b = 0.27, se.a = 0.12, se.b = 0.18, print = "mc")

# Asymptotic Normal Method
indirect(a = 0.35, b = 0.27, se.a = 0.12, se.b = 0.18, print = "asymp")
}
\references{
Aroian, L. A. (1947). The probability function of the product of two normally distributed variables.
\emph{Annals of Mathematical Statistics, 18}, 265-271. https://doi.org/10.1214/aoms/1177730442

Craig,C.C. (1936). On the frequency function of xy. \emph{Annals of Mathematical Statistics, 7}, 1–15.
https://doi.org/10.1214/aoms/1177732541

Goodman, L. A. (1960). On the exact variance of products. \emph{Journal of the American Statistical
Association, 55}, 708-713. https://doi.org/10.1080/01621459.1960.10483369

Kisbu-Sakarya, Y., MacKinnon, D. P., & Miocevic M. (2014). The distribution of the product explains
normal theory mediation confidence interval estimation. \emph{Multivariate Behavioral Research, 49},
261–268. https://doi.org/10.1080/00273171.2014.903162

MacKinnon, D. P., Lockwood, C. M., Hoffman, J. M., West, S. G., & Sheets, V. (2002). Comparison of methods
to test mediation and other intervening variable effects. \emph{Psychological Methods, 7}, 83–104.
https://doi.org/10.1037/1082-989x.7.1.83

MacKinnon, D. P., Lockwood, C. M., & Williams, J. (2004). Confidence limits for the indirect effect:
Distribution of the product and resampling methods. \emph{Multivariate Behavioral Research, 39}, 99-128.
https://doi.org/10.1207/s15327906mbr3901_4

MacKinnon, D. P., & Tofighi, D. (2013). Statistical mediation analysis. In J. A. Schinka, W. F. Velicer,
& I. B. Weiner (Eds.), \emph{Handbook of psychology: Research methods in psychology} (pp. 717-735).
John Wiley & Sons, Inc..

Meeker, W. Q., Jr., Cornwell, L. W., & Aroian, L. A. (1981). The product of two normally distributed
random variables. In W. J. Kennedy & R. E. Odeh (Eds.), \emph{Selected tables in mathematical statistics}
(Vol. 7, pp. 1–256). Providence, RI: American Mathematical Society.

Preacher, K. J., & Selig, J. P. (2012). Advantages of Monte Carlo confidence intervals for indirect effects.
\emph{Communication Methods and Measures, 6}, 77–98. http://dx.doi.org/10.1080/19312458.2012.679848

Sobel, M. E. (1982). Asymptotic confidence intervals for indirect effects in structural equation models.
In S. Leinhardt (Ed.), \emph{Sociological methodology 1982} (pp. 290-312). Washington, DC: American
Sociological Association.

Tofighi, D. & MacKinnon, D. P. (2011). RMediation: An R package for mediation analysis
confidence intervals. \emph{Behavior Research Methods, 43}, 692-700.
https://doi.org/10.3758/s13428-011-0076-x
}
\seealso{
\code{\link{multilevel.indirect}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
