% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R, R/mixdist.R, R/standist.R,
%   R/trans_standist.R
\name{d.compdist}
\alias{d.compdist}
\alias{d.trans_compdist}
\alias{d.mixdist}
\alias{d.trans_mixdist}
\alias{d}
\alias{d.standist}
\alias{d.trans_contdist}
\alias{d.trans_discrdist}
\title{Density Function}
\usage{
\method{d}{compdist}(O, x, log = FALSE)

\method{d}{trans_compdist}(O, x, log = FALSE)

\method{d}{mixdist}(O, x, log = FALSE)

\method{d}{trans_mixdist}(O, x, log = FALSE)

d(O, x, log = FALSE)

\method{d}{standist}(O, x, log = FALSE)

\method{d}{trans_contdist}(O, x, log = FALSE)

\method{d}{trans_discrdist}(O, x, log = FALSE)
}
\arguments{
\item{O}{distribution object.}

\item{x}{vector of quantiles.}

\item{log}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}
}
\value{
Vector of computed results.
}
\description{
\code{d} is a generic function that evaluates the density function of a distribution object at given values.
}
\details{
Methods of \code{d} function evaluates any offered
         distribution from the package \code{\link{mistr}}. The function makes use of the d[sufix] functions
         as \code{dnorm} or \code{dbeta} and thus, if a new distribution is added,
         these functions must be reachable through the search path.
}
\examples{
N <- normdist(1, 3)
d(N, c(NA, 1, 3, 5))

C <- cauchydist()
M <- mixdist(N, C, weights = c(0.5, 0.5))
d(M, c(NA, 1, 3, 5))

CC <- compdist(N, C, weights = c(0.5, 0.5), breakpoints = 1)
CCC <- 2*C+5
d(CCC, c(NA, 1, 3, 5))
}
