% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_cv.R
\name{nest_cv}
\alias{nest_cv}
\title{Apply Cross-Validation to Nested Data}
\usage{
nest_cv(
  nest_dt,
  v = 10,
  repeats = 1,
  strata = NULL,
  breaks = 4,
  pool = 0.1,
  ...
)
}
\arguments{
\item{nest_dt}{A \code{data.frame} or \code{data.table} containing at least one nested
\code{data.frame} or \code{data.table} column.
\itemize{
\item Supports multi-level nested structures
\item Requires at least one nested data column
}}

\item{v}{The number of partitions of the data set.}

\item{repeats}{The number of times to repeat the V-fold partitioning.}

\item{strata}{A variable in \code{data} (single character or name) used to conduct
stratified sampling. When not \code{NULL}, each resample is created within the
stratification variable. Numeric \code{strata} are binned into quartiles.}

\item{breaks}{A single number giving the number of bins desired to stratify a
numeric stratification variable.}

\item{pool}{A proportion of data used to determine if a particular group is
too small and should be pooled into another group. We do not recommend
decreasing this argument below its default of 0.1 because of the dangers
of stratifying groups that are too small.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A \code{data.table} containing the cross-validation splits for each nested dataset. It includes:
\itemize{
\item Original non-nested columns from \code{nest_dt}.
\item \code{splits}: The cross-validation split objects returned by \code{rsample::vfold_cv}.
\item \code{train}: The training data for each split.
\item \code{validate}: The validation data for each split.
}
}
\description{
The \code{nest_cv} function applies cross-validation splits to nested data frames or data tables within a data table. It uses the \code{rsample} package's \code{vfold_cv} function to create cross-validation splits for predictive modeling and analysis on nested datasets.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the input \code{nest_dt} is non-empty and contains at least one nested column of \code{data.frame}s or \code{data.table}s.
\item Identifies the nested columns and non-nested columns within \code{nest_dt}.
\item Applies \code{rsample::vfold_cv} to each nested data frame in the specified nested column(s), creating the cross-validation splits.
\item Expands the cross-validation splits and associates them with the non-nested columns.
\item Extracts the training and validation data for each split and adds them to the output data table.
}

If the \code{strata} parameter is provided, stratified sampling is performed during the cross-validation. Additional arguments can be passed to \code{rsample::vfold_cv} via \code{...}.
}
\note{
\itemize{
\item The \code{nest_dt} must contain at least one nested column of \code{data.frame}s or \code{data.table}s.
\item The function converts \code{nest_dt} to a \code{data.table} internally to ensure efficient data manipulation.
\item The \code{strata} parameter should be a column name present in the nested data frames.
\item If \code{strata} is specified, ensure that the specified column exists in all nested data frames.
\item The \code{breaks} and \code{pool} parameters are used when \code{strata} is a numeric variable and control how stratification is handled.
\item Additional arguments passed through \code{...} are forwarded to \code{rsample::vfold_cv}.
}
}
\examples{
# Example: Cross-validation for nested data.table demonstrations

# Setup test data
dt_nest <- w2l_nest(
  data = iris,                   # Input dataset
  cols2l = 1:2                   # Nest first 2 columns
)

# Example 1: Basic 2-fold cross-validation
nest_cv(
  nest_dt = dt_nest,             # Input nested data.table
  v = 2                          # Number of folds (2-fold CV)
)

# Example 2: Repeated 2-fold cross-validation
nest_cv(
  nest_dt = dt_nest,             # Input nested data.table
  v = 2,                         # Number of folds (2-fold CV)
  repeats = 2                    # Number of repetitions
)
}
\seealso{
\itemize{
\item \code{\link[rsample:vfold_cv]{rsample::vfold_cv()}} Underlying cross-validation function
\item \code{\link[rsample:initial_split]{rsample::training()}} Extract training set
\item \code{\link[rsample:initial_split]{rsample::testing()}} Extract test set
}
}
