% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOptions.R
\name{plotOptions}
\alias{plotOptions}
\title{Get forest plot options from miniMeta object}
\usage{
plotOptions(x)
}
\arguments{
\item{x}{An object of class \code{miniMeta}}
}
\value{
A named list of arguments corresponding to the arguments of 
\code{\link[meta]{forest.meta}}.
}
\description{
This function returns the forest plot options stored in a miniMeta 
object, as a named list of arguments, for further processing.
This allows finer control than directly plotting using the 
\code{\link{forest.miniMeta}} method. See the example below.
}
\examples{
\donttest{
# Extract the plot options from the miniMeta object
plot_opts <- plotOptions(example_miniMeta_obs)
# Call directly the forest.meta method, with all plot options
do.call(forest, c(x=list(example_miniMeta_obs$meta), plot_opts))

# Equivalently, call the forest.miniMeta method directly
forest(example_miniMeta_obs)
}

}
