# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' This is an helper function to compute one \code{mine} statistic.
#' It take two vectors of the same dimension as an input.
#' 
#' @param x Numeric Vector of size \code{n}
#' @param y Numeric Vector of size \code{n}
#' @param alpha numeric value representing parameter for the mine statistic see \code{\link[minerva]{mine}}
#' @param C c parameter for the mine statistic see \code{\link[minerva]{mine}}
#' @param est character estimation parameter for the mine statistic.
#' Possible values are \code{"mic_approx"} or \code{"mic_e"}
#' @param measure integer indicating which measure to return
#' @param eps eps value for MCN statistic should be in (0,1). If NA is passed then the normal MCN statistic is returned.
#' @param p probability for the generalized mic
#' @param norm boolean if require normalization between 0 and 1 for the \code{tic} statistic
#' @details This is a wrapper function to compute the mine statistic between two variables.
#' for more details on the available measure and the meaning of the other parameters see also the 
#' documentation for the \code{\link[minerva]{mine}} function.
#' @seealso \code{\link[minerva]{mine}}
#' @examples 
#' x <- runif(10); y <- 3*x+2;
#' mine_stat(x,y, measure="mic")
#' @export
mine_stat <- function(x, y, alpha = 0.6, C = 15, est = "mic_approx", measure = "mic", eps = 0.0, p = -1, norm = FALSE) {
    .Call('_minerva_mine_stat', PACKAGE = 'minerva', x, y, alpha, C, est, measure, eps, p, norm)
}

#' Compute pairwise statistics (MIC and normalized TIC) between variables
#' (convenience function).
#'
#' For each statistic, the upper triangle of the matrix is stored by row
#' (condensed matrix). If m is the number of variables, then for i < j < m, the
#' statistic between (col) i and j is stored in k = m*i - i*(i+1)/2 - i - 1 + j.
#' The length of the vectors is n = m*(m-1)/2.
#' @inheritParams cstats
#' @return
#' A matrix of (n x (n-1)/2) rows and 4 columns. The first and second column are
#' the indexes relative to the columns in the input matrix \code{x} for which the statistic is computed for.
#' Column 3 contains the MIC statistic, while column 4 contains the normalized TIC statistic. 
#' @examples
#' ## Create a matrix of random numbers
#' ## 10 variables x 100 samples
#' x <- matrix(rnorm(1000), ncol=10)
#' res <- pstats(x)
#' 
#' head(res)
#' 
#' @export
pstats <- function(x, alpha = 0.6, C = 15, est = "mic_approx") {
    .Call('_minerva_pstats', PACKAGE = 'minerva', x, alpha, C, est)
}

#' Compute statistics (MIC and normalized TIC) between each pair of the two
#' collections of variables (convenience function).
#' If n and m are the number of variables in X and Y respectively, then the
#'   statistic between the (row) i (for X) and j (for Y) is stored in \code{mic[i, j]}
#' and \code{tic[i, j]}.
#' @param x Numeric Matrix of m-by-n with n variables and m samples.
#' @param y Numeric Matrix of m-by-p with p variables and m samples.
#' @param alpha number (0, 1.0] or >=4 if alpha is in (0,1] then B will be max(n^alpha, 4) where n is the
#' number of samples. If alpha is >=4 then alpha defines directly the B
#' parameter. If alpha is higher than the number of samples (n) it will be
#' limited to be n, so B = min(alpha, n).
#' @param C number (> 0) determines how many more clumps there will be than columns in
#' every partition. Default value is 15, meaning that when trying to
#' draw x grid lines on the x-axis, the algorithm will start with at
#' most 15*x clumps.
#' @param est string ("mic_approx", "mic_e") estimator. 
#' With est="mic_approx" the original MINE statistics will
#' be computed, with est="mic_e" the equicharacteristic matrix is
#' is evaluated and MIC_e and TIC_e are returned.
#' 
#' @return list of two elements:
#' MIC: the MIC statistic matrix (n x p).
#' TIC: the normalized TIC statistic matrix (n x p).
#' @examples
#' x <- matrix(rnorm(2560), ncol=8, nrow=320)
#' y <- matrix(rnorm(1280), ncol=4, nrow=320)
#' 
#' mictic <- cstats(x, y, alpha=9, C=5, est="mic_e")
#' head(mictic)
#' 
#' @export
cstats <- function(x, y, alpha = 0.6, C = 15, est = "mic_approx") {
    .Call('_minerva_cstats', PACKAGE = 'minerva', x, y, alpha, C, est)
}

#' This set of functions are helper function to compute null distribution of the \code{tic_e} and 
#' \code{tic_e} observed distribution from a matrix
#'
#' @inheritParams mine_stat
#' @param x matrix N x M with M variables and N samples
#' @param nperm numper of permutation
#' @param seed integer to set the starting seed for random number generation (for reproducibility).
#' @describeIn mictools_null compute the \code{tic_e} null distribution
#' @return It returns a vector of \code{nperm} \code{tic_e} values.
#' @seealso \code{\link[minerva]{mictools}}
#' @export
mictools_null <- function(x, alpha = 9, C = 5, nperm = 200000L, seed = 0L) {
    .Call('_minerva_mictools_null', PACKAGE = 'minerva', x, alpha, C, nperm, seed)
}

