% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimi.R
\name{mimi}
\alias{mimi}
\title{mimi (Main effects and Interactions in Mixed and Incomplete data frames)
The method estimates main effects (group effects or effects of covariates)
and interactions in mixed data frames with missing values. The results can be used
for imputation or interpretation purposes.}
\usage{
mimi(y, model = c("covariates", "low-rank"), x = NULL, groups = NULL,
  var.type = c("gaussian", "binary", "poisson"), lambda1, lambda2,
  maxit = 100, alpha0 = NULL, theta0 = NULL, thresh = 1e-05,
  trace.it = F, max.rank = NULL)
}
\arguments{
\item{y}{nxp matrix of observations}

\item{model}{either one of "groups", "covariates" or "low-rank", indicating which model should be fitted}

\item{x}{(np)xN matrix of covariates (optional)}

\item{groups}{factor of length n indicating groups (optional)}

\item{var.type}{vector of length p indicating the data types of the columns of y (gaussian, binary or poisson)}

\item{lambda1}{positive number regularization parameter for nuclear norm penalty}

\item{lambda2}{positive number regularization parameter for l1 norm penalty}

\item{maxit}{integer maximum number of iterations}

\item{alpha0}{vector of length N: initial value of regression parameter (optional)}

\item{theta0}{matrix of size nxp: initial value of interactions (optional)}

\item{thresh}{positive number, convergence criterion}

\item{trace.it}{boolean indicating whether convergence information should be printed}

\item{max.rank}{integer, maximum rank of interaction matrix theta}
}
\value{
A list with the following elements
\item{alpha}{vector of main effects}
\item{theta}{interaction matrix}
}
\description{
mimi (Main effects and Interactions in Mixed and Incomplete data frames)
The method estimates main effects (group effects or effects of covariates)
and interactions in mixed data frames with missing values. The results can be used
for imputation or interpretation purposes.
}
\examples{
n = 6; p = 2
y1 <- matrix(rnorm(mean = 0, n * p), nrow = n)
y2 <- matrix(rnorm(mean = 0, n * p), nrow = n)
y3 <- matrix(rnorm(mean = 2, n * p), nrow = n)
y <- cbind(matrix(rnorm(mean = c(y1), n * p), nrow = n),
           matrix(rbinom(n * p, prob = c(exp(y2)/(1+exp(y2))), size = 1), nrow = n),
           matrix(rpois(n * p, lambda = c(exp(y3))), nrow = n))
var.type <- c(rep("gaussian", p), rep("binary", p), rep("poisson", p))
idx_NA <- sample(1:(3 * n * p), size = round(0.01 * 3 * n * p))
y[idx_NA] <- NA
res <- mimi(y, model = "low-rank", var.type = var.type, lambda1 = 1, maxit=5)
}
