% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_importance.R
\name{find_permuted_perf_metric}
\alias{find_permuted_perf_metric}
\title{Get permuted performance metric difference for a single feature
(or group of features)}
\usage{
find_permuted_perf_metric(
  test_data,
  trained_model,
  outcome_colname,
  perf_metric_function,
  perf_metric_name,
  class_probs,
  feat,
  test_perf_value,
  nperms = 100,
  alpha = 0.05,
  progbar = NULL
)
}
\arguments{
\item{test_data}{Held out test data: dataframe of outcome and features.}

\item{trained_model}{Trained model from \code{\link[caret:train]{caret::train()}}.}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}

\item{perf_metric_function}{Function to calculate the performance metric to
be used for cross-validation and test performance. Some functions are
provided by caret (see \code{\link[caret:postResample]{caret::defaultSummary()}}).
Defaults: binary classification = \code{twoClassSummary},
multi-class classification = \code{multiClassSummary},
regression = \code{defaultSummary}.}

\item{perf_metric_name}{The column name from the output of the function
provided to perf_metric_function that is to be used as the performance metric.
Defaults: binary classification = \code{"ROC"},
multi-class classification = \code{"logLoss"},
regression = \code{"RMSE"}.}

\item{class_probs}{Whether to use class probabilities (TRUE for categorical outcomes, FALSE for numeric outcomes).}

\item{feat}{feature or group of correlated features to permute.}

\item{test_perf_value}{value of the true performance metric on the held-out
test data.}

\item{nperms}{number of permutations to perform (default: \code{100}).}

\item{alpha}{alpha level for the confidence interval
(default: \code{0.05} to obtain a 95\% confidence interval)}

\item{progbar}{optional progress bar (default: \code{NULL})}
}
\value{
vector of mean permuted performance and mean difference between test
and permuted performance (test minus permuted performance)
}
\description{
Requires the \code{future.apply} package
}
\author{
Begüm Topçuoğlu, \email{topcuoglu.begum@gmail.com}

Zena Lapp, \email{zenalapp@umich.edu}

Kelly Sovacool, \email{sovacool@umich.edu}
}
\keyword{internal}
