% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_nodes.R
\name{mark_nodes}
\alias{mark_nodes}
\alias{node_is_isolate}
\alias{node_is_cutpoint}
\alias{node_is_core}
\alias{node_is_fold}
\alias{node_is_mentor}
\alias{node_is_latent}
\alias{node_is_infected}
\alias{node_is_recovered}
\alias{node_is_exposed}
\alias{node_is_random}
\alias{node_is_max}
\alias{node_is_min}
\title{Marking nodes based on their properties}
\usage{
node_is_isolate(.data)

node_is_cutpoint(.data)

node_is_core(.data)

node_is_fold(.data)

node_is_mentor(.data, elites = 0.1)

node_is_latent(diff_model, time = 0)

node_is_infected(diff_model, time = 0)

node_is_recovered(diff_model, time = 0)

node_is_exposed(.data, mark)

node_is_random(.data, size = 1)

node_is_max(node_measure, ranks = 1)

node_is_min(node_measure, ranks = 1)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{elites}{The proportion of nodes to be selected as mentors.
By default this is set at 0.1.
This means that the top 10\% of nodes in terms of degree,
or those equal to the highest rank degree in the network,
whichever is the higher, will be used to select the mentors.

Note that if nodes are equidistant from two mentors,
they will choose one at random.
If a node is without a path to a mentor,
for example because they are an isolate,
a tie to themselves (a loop) will be created instead.
Note that this is a different default behaviour than that
described in Valente and Davis (1999).}

\item{diff_model}{A valid network diffusion model,
as created by \code{as_diffusion()} or \code{play_diffusion()}.}

\item{time}{A time point until which infections/adoptions should be
identified. By default \code{time = 0}.}

\item{mark}{vector denoting which nodes are infected}

\item{size}{The number of nodes to select (as TRUE).}

\item{node_measure}{An object created by a \code{node_} measure.}

\item{ranks}{The number of ranks of max or min to return.
For example, \code{ranks = 3} will return TRUE for nodes with
scores equal to any of the top (or, for \code{node_is_min()}, bottom)
three scores.
By default, \code{ranks = 1}.}
}
\description{
These functions return logical vectors the length of the
nodes in a network identifying which hold certain properties or positions in the network.
\itemize{
\item \code{node_is_cutpoint()} marks nodes that cut or act as articulation points in a network,
increasing the number of connected components when removed.
\item \code{node_is_isolate()} marks nodes that are isolates,
with neither incoming nor outgoing ties.
\item \code{node_is_core()} marks nodes that are members of the network's core.
\item \code{node_is_fold()} marks nodes that are in a structural fold between two or more
triangles that are only connected by that node.
\item \code{node_is_mentor()} marks a proportion of high indegree nodes as 'mentors' (see details)
\item \code{node_is_infected()} and \code{node_is_exposed()} marks nodes that are infected
by a particular time point or exposed to a given (other) mark
\item \code{node_is_random()} marks one or more nodes at random.
\item \code{node_is_max()} and \code{node_is_min()} are more generally useful
for converting the results from some node measure into a mark-class object.
They can be particularly useful for highlighting which node or nodes
are key because they minimise or, more often, maximise some measure.
}
}
\section{Exposed}{

\code{node_is_exposed()} is similar to \code{node_exposure()},
but returns a mark (TRUE/FALSE) vector indicating which nodes
are currently exposed to the diffusion content.
This diffusion content can be expressed in the 'mark' argument.
If no 'mark' argument is provided,
and '.data' is a diff_model object,
then the function will return nodes exposure to the seed nodes
in that diffusion.
}

\examples{
node_is_isolate(ison_brandes)
node_is_cutpoint(ison_brandes)
node_is_core(ison_brandes)
node_is_fold(create_explicit(A-B, B-C, A-C, C-D, C-E, D-E))
  # To mark nodes that are latent by a particular time point
  node_is_latent(play_diffusion(create_tree(6), latency = 1), time = 1)
  # To mark nodes that are infected by a particular time point
  node_is_infected(play_diffusion(create_tree(6)), time = 1)
  # To mark nodes that are recovered by a particular time point
  node_is_recovered(play_diffusion(create_tree(6), recovery = 0.5), time = 3)
  # To mark which nodes are currently exposed
  (expos <- node_is_exposed(manynet::create_tree(14), mark = c(1,3)))
  which(expos)
node_is_random(ison_brandes, 2)
node_is_max(node_degree(ison_brandes))
node_is_min(node_degree(ison_brandes))
}
\references{
Valente, Thomas, and Rebecca Davis. 1999.
"Accelerating the Diffusion of Innovations Using Opinion Leaders",
\emph{Annals of the American Academy of Political and Social Science} 566: 56-67.
}
\seealso{
Other marks: 
\code{\link{mark_ties}}
}
\concept{marks}
