% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_layout_partition.R
\name{partition_layouts}
\alias{partition_layouts}
\alias{layout_tbl_graph_hierarchy}
\alias{layout_tbl_graph_alluvial}
\alias{layout_tbl_graph_railway}
\alias{layout_tbl_graph_ladder}
\alias{layout_tbl_graph_concentric}
\title{Layout algorithms based on bi- or other partitions}
\source{
Diego Diez, Andrew P. Hutchins and Diego Miranda-Saavedra. 2014.
"Systematic identification of transcriptional regulatory modules from
protein-protein interaction networks".
\emph{Nucleic Acids Research}, 42 (1) e6.
}
\usage{
layout_tbl_graph_hierarchy(object, circular = FALSE, times = 1000)

layout_tbl_graph_alluvial(object, circular = FALSE, times = 1000)

layout_tbl_graph_railway(object, circular = FALSE, times = 1000)

layout_tbl_graph_ladder(object, circular = FALSE, times = 1000)

layout_tbl_graph_concentric(
  object,
  membership = NULL,
  radius = NULL,
  order.by = NULL,
  circular = FALSE,
  times = 1000
)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{circular}{Should the layout be transformed into a radial representation.
Only possible for some layouts. Defaults to FALSE}

\item{times}{Maximum number of iterations, where appropriate}

\item{membership}{A vector of partition memberships.}

\item{radius}{A vector of radii at which the concentric circles
should be located.
By default this is equal placement around an empty centre,
unless one (the core) is a single node,
in which case this node occupies the centre of the graph.}

\item{order.by}{An attribute label indicating the (decreasing) order
for the nodes around the circles.
By default ordering is given by a bipartite placement that reduces
the number of edge crossings.}
}
\description{
Layout algorithms based on bi- or other partitions
}
\examples{
(autographr(ison_southern_women, "hierarchy") /
autographr(ison_southern_women, "railway")) |
autographr(ison_southern_women, "concentric")
autographr(ison_karateka, "hierarchy") 
}
\seealso{
Other mapping: 
\code{\link{autographr}()},
\code{\link{grid_layouts}}
}
\concept{mapping}
