% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipf2_stripe.R
\name{ipf2_stripe}
\alias{ipf2_stripe}
\title{Iterative Proportional Fitting Routine for the Indirect Estimation of Origin-Destination-Type Migration Flow Tables with Known Origin and Destination Margins and Stripe Elements.}
\usage{
ipf2_stripe(row_tot = NULL, col_tot = NULL, stripe_tot = NULL,
  stripe = NULL, m = NULL, tol = 1e-05, maxit = 500,
  verbose = TRUE, ...)
}
\arguments{
\item{row_tot}{Vector of origin totals to constrain the sum of the imputed cell rows.}

\item{col_tot}{Vector of destination totals to constrain the sum of the imputed cell columns.}

\item{stripe_tot}{Matrix of stripe totals to constrain the sum of the imputed cell blocks.}

\item{stripe}{Matrix of stripe stucture corresponding to \code{stripe_tot}.}

\item{m}{Matrix of auxiliary data. By default set to 1 for all origin-destination combinations.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}

\item{...}{Additional arguments passes to \code{\link{stripe_matrix}}.}
}
\value{
Iterative Proportional Fitting routine set up using the partial likelihood derivatives. The arguments \code{row_tot} and \code{col_tot} take the row-table and column-table specific known margins. The \code{stripe_tot} take the totals over the stripes in the matrix defined with \code{b}. Diagonal values can be added by the user, but care must be taken to ensure resulting diagonals are feasible given the set of margins. 
The user must ensure that the row and column totals in each table sum to the same value. Care must also be taken to allow the dimension of the auxiliary matrix (\code{m}) equal those provided in the row and column totals.
Returns a \code{list} object with
\item{mu }{Array of indirect estimates of origin-destination matrices by migrant characteristic}
\item{it }{Iteration count}
\item{tol }{Tolerance level at final iteration}
}
\description{
The \code{ipf2.b} function finds the maximum likelihood estimates for fitted values in the log-linear model:
\deqn{ \log y_{pq} = \log \alpha_{p} + \log \beta_{q} + \log \lambda_{ij}I(p \in i, q \in j) + \log m_{pq} }
where \eqn{m_{pq}} is a prior estimate for \eqn{y_{pq}} and is no more complex than the matrices being fitted. The \eqn{\lambda_{ij}I(p \in i, q \in j)} term ensures a saturated fit on the block the \eqn{(i,j)} block.
}
\examples{
y <- ipf2_stripe(row_tot = c(85, 70, 35, 30, 60, 55, 65),
 stripe_tot = matrix(c(15,20,50,
                35,10,25,
                5 ,0 ,30,
                10,10,10,
                30,30,0,
                15,30,10,
                35,25,5 ), ncol = 3, byrow = TRUE),
 stripe = stripe_matrix(x = 1:21, s = c(2,2,3), byrow = TRUE))
 addmargins(y$mu)
}
\seealso{
\code{\link{stripe_matrix}}, \code{\link{block_matrix}}, \code{\link{block_sum}}
}
\author{
Guy J. Abel
}
