% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midasml_functions.R
\name{qtarget.sort_midasml}
\alias{qtarget.sort_midasml}
\title{High-dimensional mixed frequency data sort function}
\usage{
qtarget.sort_midasml(y.data, x.macro.data = NULL, x.real.time = NULL,
  x.quarterly_group = NULL, x.lag = NULL, legendre_degree, horizon, 
  macro_delay = 1, est.start, est.end, standardize = TRUE, group_ar_lags = FALSE, 
  real_time_predictions = FALSE, disp.flag = TRUE)
}
\arguments{
\item{y.data}{response variable data.}

\item{x.macro.data}{macro data which is not real-time, i.e. is used with publication delay defined in \ifelse{html}{\out{<code>macro_delay</code>}}{\code{macro_delay}}.}

\item{x.real.time}{real-time data.}

\item{x.quarterly_group}{quarterly data currently taken as real-time data.}

\item{x.lag}{single value or vector of size of the total number of variables defining the number of lags for each high-frequency variable in \ifelse{html}{\out{<code>x.macro.data, x.real.time</code>}}{\code{x.macro.data, x.real.time}}.}

\item{legendre_degree}{single value or vector of size of the total number of variables defining the polynomial degree for each each high-frequency variable in \ifelse{html}{\out{<code>x.macro.data, x.real.time</code>}}{\code{x.macro.data, x.real.time}}.}

\item{horizon}{forecast horizon relative to \ifelse{html}{\out{<code>y.data</code>}}{\code{y.data}} date column in high-frequency time units.}

\item{macro_delay}{number of months that macro series in \ifelse{html}{\out{<code>x.macro.data</code>}}{\code{x.macro.data}} are delayed.}

\item{est.start}{estimation start date, taken as the first ... .}

\item{est.end}{estimation end date, taken as the last ... . Remainig data after this date is dropped to out-of-sample evaluation data.}

\item{standardize}{TRUE/FALSE to standardize high-frequneyc covariates in high-frequency units.}

\item{group_ar_lags}{TRUE/FALSE to group AR lags.}

\item{real_time_predictions}{TRUE/FALSE in case real-time data is used for predictions}

\item{disp.flag}{display flag to indicate whether or not to display obtained MIDAS data structure in console.}
}
\value{
MIDAS covariates and group memberships based on desired specification.
}
\description{
Sorts high-dimensional mixed frequency data for quarterly target variable.
}
\details{
\ifelse{html}{\out{Sorts high-dimensional mixed frequency data for quarterly target variable read to be inputed into <code>midasml_forecast</code> function to produce nowcasts & forecasts.}}{Sorts high-dimensional mixed frequency data for quarterly target variable read to be inputed into \code{midasml_forecast} function to produce nowcasts & forecasts.}
}
\examples{
\donttest{
data(macro_midasml)
est.start <- as.Date("1990-12-01")
est.end <- as.Date("2017-03-01")
rgdp.data <- macro_midasml$rgdp.data
rgdp.data <- rgdp.data[rgdp.data$DATE<=as.Date("2017-06-01"),]
qtarget.sort_midasml(y.data = rgdp.data, x.macro.data = macro_midasml$md.data, 
         x.real.time = macro_midasml$text.data, x.quarterly_group = macro_midasml$survey.data, 
         x.lag = 12, legendre_degree = 3, 
         horizon = 1, macro_delay = 1, est.start, est.end, 
         standardize = TRUE, group_ar_lags = FALSE, disp.flag = FALSE)
}
}
\author{
Jonas Striaukas
}
