% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{scoretest}
\alias{scoretest}
\alias{scoretest.default}
\alias{scoretest.micsr}
\title{Score test}
\usage{
scoretest(object, ...)

\method{scoretest}{default}(object, ...)

\method{scoretest}{micsr}(object, ..., vcov = NULL)
}
\arguments{
\item{object}{the first model,}

\item{...}{for the \code{micsr} method, it should be the formula for the
"large" model or an object from which a formula can be
extracted}

\item{vcov}{an optional covariance matrix}
}
\value{
an object of class \code{"htest"}.
}
\description{
Score test, also knowned as Lagrange multiplier tests
}
\examples{
mode_choice <- transform(mode_choice, cost = cost * 8.42)
mode_choice <- transform(mode_choice, gcost = (ivtime + ovtime) * 8 + cost)
pbt_unconst <- binomreg(mode ~ cost + ivtime + ovtime, data = mode_choice, link = "probit")
pbt_const <- binomreg(mode ~ gcost, data = mode_choice, link = "logit")
scoretest(pbt_const , . ~ . + ivtime + ovtime)
}
\author{
Yves Croissant
}
\keyword{htest}
